% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fclust.R
\name{remove_components}
\alias{remove_components}
\title{Remove components from dataset}
\usage{
remove_components(fobs, mOccur, components)
}
\arguments{
\item{fobs}{a numeric vector. The vector \code{fobs} contains the
quantitative performances of assemblages.}

\item{mOccur}{a matrix of occurrence (occurrence of elements).
Its first dimension equals to \code{length(fobs)}. Its second dimension
 equals to the number of elements.}

\item{components}{a list of strings,
that indicates the components to remove from the matrix of occurrence
and from vector (or matrix) of assemblage performances.
The components to remove must belong to colnames of mOccur.}
}
\value{
Return a list containing:
\itemize{
\code{$fobs}    : the matrix of averaged performances of unique assemblages.
\code{$mOccur} : the matrix of occurrence of unique assemblages.
}
}
\description{
Remove one or more components from a dataset.
}
\details{
None.
}
\keyword{internal}
