% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validating_jack.R
\name{validate_amean_bymot_jack}
\alias{validate_amean_bymot_jack}
\title{Predicting the performances
 by assembly motif
 using jackknife method}
\usage{
validate_amean_bymot_jack(fobs, assMotif, jack)
}
\arguments{
\item{fobs}{a numeric vector. The vector \code{fobs} contains the
quantitative performances of assemblages.}

\item{assMotif}{a vector of labels of \code{length(fobs)}.
The vector \code{assMotif} contains the assembly motifs of assemblages.}

\item{jack}{an integer vector of length \code{2}.
The vector specifies the parameters for jackknife method.
The first integer \code{jack[1]} specifies the size of subset,
the second integer \code{jack[2]} specifies the number of subsets.}
}
\value{
Return a vector of \code{length(fobs)}.
Its values are computed as the arithmetic mean
of performances of assemblages
that share a same assembly motif,
by excluding a subset of assemblages
containing the assemblage to predict.
}
\description{
Take a vector \code{fobs} of assembly performances
and return a vector of performances predicted
as the arithmetic mean of performances of other assemblages
that share the same assembly motif. \cr

Assembly motifs are labelled in the vector \code{assMotif}.
}
\details{
Predicted performances are computed
using arithmetic mean (\code{opt.mean = "amean"})
of performances of assemblages
  that share a same assembly motif (\code{opt.model = "bymot"}).

The assemblages belonging to a same assembly motif are divided
 into \code{jack[2]} subsets of \code{jack[1]} assemblages.
  Prediction is computed by excluding \code{jack[1]} assemblages,
  including the assemblage to predict.
   If the total number of assemblages belonging
  to the assembly motif is lower than \code{jack[1]*jack[2]},
   prediction is computed by Leave-One-Out (LOO).
}
\seealso{
\code{\link{validate_amean_byelt_jack_xpr}},
         \code{\link{validate_gmean_bymot_jack_xpr}},
         \code{\link{validate_gmean_byelt_jack_xpr}}
}
\keyword{internal}
