% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.faMB.R
\name{summary.faMB}
\alias{summary.faMB}
\title{Summary Method for an Object of Class faMB}
\usage{
\method{summary}{faMB}(
  object,
  digits = 2,
  Set = 1,
  HPthreshold = 0.05,
  PrintLevel = 1,
  DiagnosticsLevel = 1,
  ...
)
}
\arguments{
\item{object}{(Object of class \code{\link{faMB}}) The returned object 
from a call to \strong{faMB}.}

\item{digits}{(Integer) Print output with user-specified number of significant digits. 
Default \code{digits = 2}.}

\item{Set}{The argument \code{Set} can be specified as either an integer 
  value (i.e., 1 through the number of unique solution sets) or a character 
  value (i.e., 'UnSpun'). 
\itemize{
  \item{\strong{Integer}} Summarize the solution from the specified 
  solution set. If \code{Set = 1}, the "global minimum" solution is 
  reported. See \code{\link{faMain}} for more details about finding 
  the "global" and local minima. 
  \item{\strong{'UnSpun'}} Summarize the solution from the rotated 
  output that was produced by rotating from the unrotated (i.e., unspun) 
  factor orientation. All other solutions are rotated from a randomly 'spun' rotation 
  (i.e., by orientating the unrotated factor solution via a random orthonormal 
  matrix) . 
 }}

\item{HPthreshold}{(Numeric) User-defined threshold for declaring that the 
absolute value of a factor pattern coefficient is in a hyperplane. The hyperplane count is the number of 
near-zero (as defined by HPthreshold; see Cattell, 1978, p. 105) elements in the factor pattern matrix. 
Default \code{HPthreshold = .05}.}

\item{PrintLevel}{(Integer) Controls the level of printing. If \code{PrintLevel = 0} then no output is printed. 
If \code{PrintLevel = 1} then the standard output 
will be printed. If \code{PrintLevel = 2} more extensive output (e.g., the Factor Structure Matrix, 
the Residuals Matrix [i.e., Observed - fitted R]) will 
be printed. Default \code{PrintLevel = 1}.}

\item{DiagnosticsLevel}{(Integer) Controls the amount of diagnostics information that is computed on the 
rotation local minima. If \code{DiagnosticsLevel = 1} then only the number 
of local solution sets will be reported. If \code{DiagnosticsLevel = 2} then
the program will determine whether all solutions within a solution set are identicial.
Default \code{DiagnosticsLevel = 1}.}

\item{\dots}{Additional arguments affecting the summary produced.}
}
\value{
\itemize{
    \item \code{loadings} (Matrix) Factor loadings for the solution associated with the 
                   minimum (maximum) rotation complexity value (default) or the user-chosen solution.
     \item \code{Phi} (Matrix) Factor correlation matrix for the solution associated with the 
                   minimum (maximum) rotation complexity value (default) or the user-chosen solution.
     \item \code{FS} (Matrix) Factor structure matrix  for the solution associated with the 
                   minimum (maximum) rotation complexity value (default) or the user-chosen solution.
     \item \code{Set} (Integer) The returned Set number. 
     \item \code{facIndeterminacy} (Matrix) Factor Indeterminacy values. 
     \item \code{SetComplexityValues} (vector) Rotation complexity value for each solution set. 
     \item \code{HP_counts} (vector) Hyperplane count for each solution set.  
     \item \code{MaxWithinSetRMSD} (vector) If \code{DiagnosticsLevel = 2} the the program will compute
     within set RMSD values.  These values represent the root mean squared deviations of each 
     within set solution with the first solution in a set. If the \code{MaxWithinSetRMSD = 0} 
     for a set, then all within set solutions are identical. If  \code{MaxWithinSetRMSD > 0} 
     then at least one solution differs from the remaining solutions within a set (i.e., two solutions 
     with different factor loadings produced identical complexity values). 
     \item \code{ChiSq} (Numeric) Chi-square goodness of fit value. As recommended by Browne (1979), 
     we apply Lawley's (1959) correction when computing the chi-square value when \code{NB = 2}.
     \item \code{DF} (Numeric) Degrees of freedom for the estimated model. 
     \item \code{pvalue} (Numeric) P-value associated with the above chi-square statistic.
     \item \code{AIC} (Numeric) Akaike's Information Criterion where a lower value indicates better fit. 
     \item \code{BIC} (Numeric) Bayesian Information Criterion where a lower value indicates better fit. 
     \item \code{RMSEA} (Numeric) The root mean squared error of approximation (Steiger & Lind, 1980).
     \item \code{Resid} (Matrix) The residuals matrix (R - Rhat). 
     \item \code{NumberLocalSolutions} (Integer) The number of local solution sets.     
     \item \code{LocalSolutions} (List) A list of local solutions (factor loadings, factor correlations, etc). 
     \item\code{rotate} Designates which rotation method was applied.
   }
}
\description{
This function summarizes results from a call to \strong{faMB}.
}
\details{
\strong{summary.faMB} provides various criteria for judging the adequacy of 
the rotated factor solution(s). After reporting the number of solution sets.
(i.e., rotated solutions with the same complexity value) the following measures 
  of factor adequacy are reported for each solution set:
\itemize{
 \item \strong{Complexity Value}: The rotation complexity value (see \code{\link{faMain}} for details).
 \item \strong{Hyperplane Count}: The number of near-zero loadings (defined by \strong{HPthreshold}) 
   for all factor patterns in a solution set (if \strong{MaxWithinSetRMSD > 0} then Hyperplane Count refers to 
 the first factor pattern in the solution set). 
 \item \strong{\% Cases (x 100) in Set}: The percentage of factor patterns in each solution set.
 \item \strong{RMSD}: The root mean squared deviation between the first factor pattern 
   in each solution set with the first factor pattern  in the solution set specified by the \strong{Set} parameter. By default, \strong{Set = 1}.
 \item \strong{MaxWithinSetRMSD}: The maximum root mean squared deviation between all within set solutions and 
 the first element in the solution set. When \strong{MaxWithinSetRMSD > 0} then the solution 
 set contains non-identical rotated factor patterns with identical complexity values. 
 \item \strong{Converged}: A Logical (TRUE/FALSE) that  indicates whether all within set rotations converged.
 }
}
\examples{
# These examples reproduce published multiple battery analyses. 

# ----EXAMPLE 1: Browne, M. W. (1979)----
#
# Data originally reported in:
# Thurstone, L. L. & Thurstone, T. G. (1941). Factorial studies 
# of intelligence. Psychometric Monograph (2), Chicago: Univ. 
# Chicago Press.

## Load Thurstone & Thurstone's data used by Browne (1979)
data(Thurstone41)

Example1Output <-  faMB(R             = Thurstone41, 
                        n             = 710,
                        NB            = 2, 
                        NVB           = c(4,5), 
                        numFactors    = 2,
                        rotate        = "oblimin",
                        rotateControl = list(standardize = "Kaiser"))
                        
## Call the summary function
summary(Example1Output)

# ----EXAMPLE 2: Browne, M. W. (1980)----
# Data originally reported in:
# Jackson, D. N. & Singer, J. E. (1967). Judgments, items and 
# personality. Journal of Experimental Research in Personality, 20, 70-79.

## Load Jackson and Singer's dataset
data(Jackson67)

Example2Output <-  faMB(R             = Jackson67, 
                        n             = 480,
                        NB            = 5, 
                        NVB           = rep(4,5), 
                        numFactors    = 4,
                        rotate        = "varimax",
                        rotateControl = list(standardize = "Kaiser"),
                        PrintLevel    = 1)

## Call the summary function
summary(object     = Example2Output,
        Set        = 1,
        PrintLevel = 1)

# ----EXAMPLE 3: Cudeck (1982)----
# Data originally reported by:
# Malmi, R. A., Underwood, B. J., & Carroll, J. B. (1979).
# The interrelationships among some associative learning tasks. 
# Bulletin of the Psychonomic Society, 13(3), 121-123. DOI: 10.3758/BF03335032 

## Load Malmi et al.'s dataset
data(Malmi79)

Example3Output <- faMB(R             = Malmi79, 
                       n             = 97,
                       NB            = 3, 
                       NVB           = c(3, 3, 6), 
                       numFactors    = 2,
                       rotate        = "oblimin",
                       rotateControl = list(standardize = "Kaiser"))

## Call the summary function
summary(object     = Example3Output,
        Set        = 1,
        PrintLevel = 2)
        
# ----Example 4: Cudeck (1982)----
# Data originally reported by: 
# Boruch, R. F., Larkin, J. D., Wolins, L. and MacKinney, A. C. (1970). 
#  Alternative methods of analysis: Multitrait-multimethod data. Educational 
#  and Psychological Measurement, 30,833-853.

## Load Boruch et al.'s dataset
data(Boruch70)

Example4Output <- faMB(R             = Boruch70,
                       n             = 111,
                       NB            = 2,
                       NVB           = c(7,7),
                       numFactors    = 2,
                       rotate        = "oblimin",
                       rotateControl = list(standardize  = "Kaiser",
                                            numberStarts = 100))

## Call the summary function
summary(Example4Output)

}
\references{
Cattell, R. (1978). The scientific use of factor analysis in behavioral and life sciences. 
 New York, New York, Plenum.
}
\seealso{
Other Factor Analysis Routines: 
\code{\link{BiFAD}()},
\code{\link{Box26}},
\code{\link{GenerateBoxData}()},
\code{\link{Ledermann}()},
\code{\link{SLi}()},
\code{\link{SchmidLeiman}()},
\code{\link{faAlign}()},
\code{\link{faEKC}()},
\code{\link{faIB}()},
\code{\link{faLocalMin}()},
\code{\link{faMB}()},
\code{\link{faMain}()},
\code{\link{faScores}()},
\code{\link{faSort}()},
\code{\link{faStandardize}()},
\code{\link{faX}()},
\code{\link{fals}()},
\code{\link{fapa}()},
\code{\link{fareg}()},
\code{\link{orderFactors}()},
\code{\link{print.faMB}()},
\code{\link{print.faMain}()},
\code{\link{promaxQ}()},
\code{\link{summary.faMain}()}
}
\author{
\itemize{
  \item Niels G. Waller (nwaller@umn.edu)
  \item Casey Giordano (Giord023@umn.edu)
  }
}
\concept{Factor Analysis Routines}
