% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowmeans.R
\name{mutate_rowmeans}
\alias{mutate_rowmeans}
\title{Get Row Means within a Pipe}
\usage{
mutate_rowmeans(data, new_var, ..., na.rm = FALSE)
}
\arguments{
\item{data}{the dataframe that contains the variables to get the row means from}

\item{new_var}{the name of the new variable for which you'll put the row means in quotes}

\item{...}{the variables (unquoted) to be included in the row means}

\item{na.rm}{should the missing values be ignored? default is FALSE}
}
\value{
the row means included within the data.frame
}
\description{
Does what \code{rowMeans()} does can be used one its own without dplyr::mutate() 
within a pipe.
}
\examples{

\dontrun{

library(furniture)
library(tidyverse)

data <- data.frame(
  x = sample(c(1,2,3,4), 100, replace=TRUE),
  y = rnorm(100),
  z = rnorm(100)
)

data2 <- data \%>\%
  mutate_rowmeans("y_z_mean", y, z))
data2 <- data \%>\%
  mutate_rowmeans("y_z_mean", y, z, na.rm=TRUE))

}

}
