% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarSel.R
\name{VarSel}
\alias{VarSel}
\title{Varsel Class}
\description{
This class implements a learner. A \link{VarSel} object can only exist as a component of a
\link{TrainLayer} or a \link{TrainMetaLayer} object.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-VarSel-new}{\code{VarSel$new()}}
\item \href{#method-VarSel-print}{\code{VarSel$print()}}
\item \href{#method-VarSel-summary}{\code{VarSel$summary()}}
\item \href{#method-VarSel-interface}{\code{VarSel$interface()}}
\item \href{#method-VarSel-varSelection}{\code{VarSel$varSelection()}}
\item \href{#method-VarSel-getTrainLayer}{\code{VarSel$getTrainLayer()}}
\item \href{#method-VarSel-getId}{\code{VarSel$getId()}}
\item \href{#method-VarSel-getPackage}{\code{VarSel$getPackage()}}
\item \href{#method-VarSel-getVarSubSet}{\code{VarSel$getVarSubSet()}}
\item \href{#method-VarSel-getParamInterface}{\code{VarSel$getParamInterface()}}
\item \href{#method-VarSel-getNaAction}{\code{VarSel$getNaAction()}}
\item \href{#method-VarSel-getExtractVar}{\code{VarSel$getExtractVar()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VarSel-new"></a>}}
\if{latex}{\out{\hypertarget{method-VarSel-new}{}}}
\subsection{Method \code{new()}}{
Variable selection parameter list.

Learner ID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VarSel$new(
  id,
  package = NULL,
  varsel_fct,
  varsel_param,
  train_layer,
  na_action = "na.rm"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character} \cr
Package that implements the variable selection function.
If NULL, the variable selection  function is called from
the current environment.}

\item{\code{package}}{\code{character} \cr
Variable selection function name. Note: Variable selection functions, except \code{Boruta}, must return a vector of selected variables.}

\item{\code{varsel_fct}}{\code{character} \cr
Variable selection parameters.}

\item{\code{varsel_param}}{\code{list} \cr
Layer on which the learner is stored.}

\item{\code{train_layer}}{\code{TrainLayer} \cr
The training layer where to store the learner.}

\item{\code{na_action}}{\code{character} \cr
Handling of missing values in meta-data. Set to "na.keep" to keep missing values, "na.rm" to remove individuals with missing values or "na.impute" (only applicable on meta-data) to impute missing values in meta-data. Only median and mode based imputations are actually handled. With the "na.keep" option, ensure that the provided learner can handle missing values.
If \code{TRUE}, the individuals with missing predictor values will be removed from the training dataset.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VarSel-print"></a>}}
\if{latex}{\out{\hypertarget{method-VarSel-print}{}}}
\subsection{Method \code{print()}}{
Printer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VarSel$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\code{any}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VarSel-summary"></a>}}
\if{latex}{\out{\hypertarget{method-VarSel-summary}{}}}
\subsection{Method \code{summary()}}{
Summary
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VarSel$summary(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\code{any}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VarSel-interface"></a>}}
\if{latex}{\out{\hypertarget{method-VarSel-interface}{}}}
\subsection{Method \code{interface()}}{
Learner and prediction parameter interface. Use this function
to provide how the following parameters are named in the learning
function (\code{lrn_fct}) you provided when creating the learner, or in the predicting function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VarSel$interface(
  x = "x",
  y = "y",
  object = "object",
  data = "data",
  extract_var_fct = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{\code{string} \cr
Name of the argument to pass the matrix of independent variables in the original learning function.}

\item{\code{y}}{\code{string} \cr
Name of the argument to pass the response variable in the original learning function.}

\item{\code{object}}{\code{string} \cr
Name of the argument to pass the model in the original predicting function.}

\item{\code{data}}{\code{character} \cr
Name of the argument to pass new data in the original predicting function.}

\item{\code{extract_var_fct}}{\code{character} or \code{function} \cr
If the variable selection function that is called does not return a vector, then
use this argument to specify a (or a name of a) function that can be used to extract vector of selected variables.
Default value is NULL, if selected variables are in a vector.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VarSel-varSelection"></a>}}
\if{latex}{\out{\hypertarget{method-VarSel-varSelection}{}}}
\subsection{Method \code{varSelection()}}{
Tains the current learner (from class \link{Lrner}) on the current training data (from class \link{TrainData}).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VarSel$varSelection(ind_subset = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ind_subset}}{\code{vector} \cr
Individual ID subset on which the training will be performed.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The resulting model, from class \link{Model}, is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VarSel-getTrainLayer"></a>}}
\if{latex}{\out{\hypertarget{method-VarSel-getTrainLayer}{}}}
\subsection{Method \code{getTrainLayer()}}{
The current layer is returned.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VarSel$getTrainLayer()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\link{TrainLayer} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VarSel-getId"></a>}}
\if{latex}{\out{\hypertarget{method-VarSel-getId}{}}}
\subsection{Method \code{getId()}}{
Getter of the current learner ID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VarSel$getId()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The current learner ID.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VarSel-getPackage"></a>}}
\if{latex}{\out{\hypertarget{method-VarSel-getPackage}{}}}
\subsection{Method \code{getPackage()}}{
Getter of the variable selection package implementing the variable selection function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VarSel$getPackage()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The name of the package implementing the variable selection function.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VarSel-getVarSubSet"></a>}}
\if{latex}{\out{\hypertarget{method-VarSel-getVarSubSet}{}}}
\subsection{Method \code{getVarSubSet()}}{
Getter of the list of selected variables.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VarSel$getVarSubSet()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
List of selected variables..
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VarSel-getParamInterface"></a>}}
\if{latex}{\out{\hypertarget{method-VarSel-getParamInterface}{}}}
\subsection{Method \code{getParamInterface()}}{
The current parameter interface is returned.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VarSel$getParamInterface()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A data.frame of interface.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VarSel-getNaAction"></a>}}
\if{latex}{\out{\hypertarget{method-VarSel-getNaAction}{}}}
\subsection{Method \code{getNaAction()}}{
The current layer is returned.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VarSel$getNaAction()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VarSel-getExtractVar"></a>}}
\if{latex}{\out{\hypertarget{method-VarSel-getExtractVar}{}}}
\subsection{Method \code{getExtractVar()}}{
The function to extract selected variables is returned.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VarSel$getExtractVar()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A data.frame of interface.
}
}
}
