% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{teststat.boottest}
\alias{teststat.boottest}
\title{S3 method to obtain the non-bootstrapped t-statistic calculated
via \code{boottest()}}
\usage{
\method{teststat}{boottest}(object, ...)
}
\arguments{
\item{object}{An object of type boottest}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A vector containing the non-bootstrapped t-statistic
calculated in \code{boottest()}
}
\description{
S3 method to obtain the non-bootstrapped t-statistic calculated
via \code{boottest()}
}
\examples{
requireNamespace("fwildclusterboot")
data(voters)
lm_fit <- lm(
  proposition_vote ~ treatment + ideology1 + log_income + Q1_immigration,
  data = voters
)
boot <- boottest(lm_fit,
  B = 9999,
  param = "treatment",
  clustid = "group_id1"
)
teststat(boot)

}
