/*
 * Decompiled with CFR 0.152.
 */
package junit;

import java.util.List;
import junit.RVector_Test;
import org.af.jhlir.call.RCallServices;
import org.af.jhlir.call.RInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RInteger_Test
extends RVector_Test {
    private RInteger rInt1;
    private RInteger rInt2;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rInt1 = this.getRServices().eval("as.integer(c(1, 5, NA, 3, 10, NA))").asRInteger();
        this.rInt2 = this.getRServices().eval("1:3").asRInteger();
        this.registerVecs(this.rInt1, this.rInt2);
    }

    @Test
    public void testAt() {
        int[] xs = this.rInt1.getData();
        Assert.assertEquals((long)this.rInt1.getLength(), (long)6L);
        Assert.assertEquals(this.rInt1.get(0), (Object)1);
        Assert.assertFalse((boolean)this.rInt1.isNA(0));
        Assert.assertEquals(this.rInt1.get(1), (Object)5);
        Assert.assertFalse((boolean)this.rInt1.isNA(1));
        Assert.assertEquals(this.rInt1.get(2), (Object)RCallServices.NA_RINTEGER);
        Assert.assertTrue((boolean)this.rInt1.isNA(2));
        Assert.assertEquals(this.rInt1.get(3), (Object)3);
        Assert.assertFalse((boolean)this.rInt1.isNA(3));
        Assert.assertEquals(this.rInt1.get(4), (Object)10);
        Assert.assertFalse((boolean)this.rInt1.isNA(4));
        Assert.assertEquals(this.rInt1.get(5), (Object)RCallServices.NA_RINTEGER);
        Assert.assertTrue((boolean)this.rInt1.isNA(5));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void outOfBounds() {
        this.rInt1.get(-1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void outOfBounds2() {
        this.rInt1.get(6);
    }

    @Test
    public void testGetDataAsObjArr() {
        Integer[] xs = this.rInt1.getDataAsObjArr();
        Assert.assertEquals((long)xs.length, (long)6L);
        Assert.assertEquals((long)xs[0].intValue(), (long)1L);
        Assert.assertEquals((long)xs[1].intValue(), (long)5L);
        Assert.assertEquals((long)xs[2].intValue(), (long)RCallServices.NA_RINTEGER.intValue());
        Assert.assertEquals((long)xs[3].intValue(), (long)3L);
        Assert.assertEquals((long)xs[4].intValue(), (long)10L);
        Assert.assertEquals((long)xs[5].intValue(), (long)RCallServices.NA_RINTEGER.intValue());
    }

    @Test
    public void testAsList() {
        List<Integer> xs = this.rInt1.getDataAsList();
        Assert.assertEquals((long)xs.size(), (long)6L);
        Assert.assertEquals((Object)xs.get(0), (Object)1);
        Assert.assertEquals((Object)xs.get(1), (Object)5);
        Assert.assertEquals((Object)xs.get(2), (Object)RCallServices.NA_RINTEGER);
        Assert.assertEquals((Object)xs.get(3), (Object)3);
        Assert.assertEquals((Object)xs.get(4), (Object)10);
        Assert.assertEquals((Object)xs.get(5), (Object)RCallServices.NA_RINTEGER);
    }
}

