/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.DecimalFormat;
import java.util.Vector;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.graph.Edge;
import org.af.gMCP.gui.graph.NetList;
import org.af.gMCP.gui.graph.NodeListener;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;

public class Node {
    public Vector<NodeListener> listener = new Vector();
    int x;
    int y;
    private String name;
    NetList nl;
    private double weight;
    private String stringW = "";
    private Color color = Color.WHITE;
    boolean rejected = false;
    public static int r = 25;
    static DecimalFormat format = new DecimalFormat("#.####");
    static DecimalFormat formatSmall = new DecimalFormat("#.###E0");
    int lastFontSize = 14;
    static int count = 1;
    TeXIcon iconName;
    TeXIcon iconWeight;
    Double localPower = null;

    public static void setRadius(int radius) {
        r = radius;
    }

    public Node(String name, int x, int y, double alpha, NetList vs) {
        ++count;
        this.nl = vs;
        this.setName(name);
        this.setX(x);
        this.setY(y);
        this.setWeight(alpha, null);
    }

    public int[] offset(int x2, int y2) {
        return new int[]{(int)((double)this.x * this.nl.getZoom()) - x2, (int)((double)this.y * this.nl.getZoom()) - y2};
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        int grid = Configuration.getInstance().getGeneralConfig().getGridSize();
        this.x = x = (x + (int)(0.5 * (double)grid)) / grid * grid;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        int grid = Configuration.getInstance().getGeneralConfig().getGridSize();
        this.y = y = (y + (int)(0.5 * (double)grid)) / grid * grid;
    }

    public void paintYou(Graphics g) {
        Rectangle2D rc;
        if (this.rejected && !Configuration.getInstance().getGeneralConfig().showRejected()) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setFont(new Font("Arial", 0, (int)(12.0 * this.nl.getZoom())));
        FontRenderContext frc = g2d.getFontRenderContext();
        g2d.setColor(this.getColor());
        Ellipse2D.Double e = new Ellipse2D.Double();
        ((RectangularShape)e).setFrame((double)this.x * this.nl.getZoom(), (double)this.y * this.nl.getZoom(), (double)(r * 2) * this.nl.getZoom(), (double)(r * 2) * this.nl.getZoom());
        g2d.fill(e);
        g2d.setColor(new Color(0, 0, 0));
        ((RectangularShape)e).setFrame((double)this.x * this.nl.getZoom(), (double)this.y * this.nl.getZoom(), (double)(r * 2) * this.nl.getZoom(), (double)(r * 2) * this.nl.getZoom());
        g2d.draw(e);
        if (this.localPower != null) {
            String s = format.format(this.localPower);
            rc = g2d.getFont().getStringBounds(s, frc);
            g2d.drawString(s, (float)((double)(this.x + r) * this.nl.getZoom() - rc.getWidth() / 2.0), (float)(((double)this.y + 2.5 * (double)r) * this.nl.getZoom()));
        }
        if (!Configuration.getInstance().getGeneralConfig().useJLaTeXMath()) {
            rc = g2d.getFont().getStringBounds(this.name, frc);
            g2d.drawString(this.name, (float)((double)(this.x + r) * this.nl.getZoom() - rc.getWidth() / 2.0), (float)(((double)(this.y + r) - 0.25 * (double)r) * this.nl.getZoom()));
            rc = g2d.getFont().getStringBounds(this.getWS(), frc);
            g2d.drawString(this.getWS(), (float)((double)(this.x + r) * this.nl.getZoom() - rc.getWidth() / 2.0), (float)(((double)this.y + 1.5 * (double)r) * this.nl.getZoom()));
        } else {
            if (this.lastFontSize != (int)(14.0 * this.nl.getZoom())) {
                this.lastFontSize = (int)(14.0 * this.nl.getZoom());
                this.iconWeight = Edge.getTeXIcon(this.nl.control.getGraphGUI(), this.stringW, this.lastFontSize);
                TeXFormula formula = new TeXFormula("\\mathbf{" + this.name + "}");
                this.iconName = formula.createTeXIcon(2, (float)this.lastFontSize);
            }
            this.iconName.paintIcon(Edge.panel, (Graphics)g2d, (int)((double)(this.x + r) * this.nl.getZoom() - (double)(this.iconName.getIconWidth() / 2)), (int)(((double)(this.y + r) - 0.6 * (double)r) * this.nl.getZoom()));
            this.iconWeight.paintIcon(Edge.panel, (Graphics)g2d, (int)((double)(this.x + r) * this.nl.getZoom() - (double)(this.iconWeight.getIconWidth() / 2)), (int)(((double)this.y + 1.1 * (double)r) * this.nl.getZoom()));
        }
    }

    private String getWS() {
        return this.stringW;
    }

    public static int getRadius() {
        return r;
    }

    public boolean inYou(int x, int y) {
        return ((double)x / this.nl.getZoom() - (double)this.x - (double)r) * ((double)x / this.nl.getZoom() - (double)this.x - (double)r) + ((double)y / this.nl.getZoom() - (double)this.y - (double)r) * ((double)y / this.nl.getZoom() - (double)this.y - (double)r) <= (double)(r * r);
    }

    public void setWeight(double w, NodeListener me) {
        this.weight = w;
        DecimalFormat format = Configuration.getInstance().getGeneralConfig().getDecFormat();
        if (!Configuration.getInstance().getGeneralConfig().showFractions()) {
            this.stringW = format.format(w);
        } else if (this.weight != 0.0 && this.weight < Math.pow(0.1, 3.0)) {
            this.stringW = formatSmall.format(this.weight);
        } else {
            this.stringW = RControl.getFraction((Double)w, 5);
            if (this.stringW.length() > 7) {
                this.stringW = "\\sim " + format.format(w);
            }
        }
        this.iconWeight = Edge.getTeXIcon(this.nl.control.getGraphGUI(), this.stringW, (int)(14.0 * this.nl.getZoom()));
        for (NodeListener l : this.listener) {
            if (me == l) continue;
            l.updated(this);
        }
        this.nl.graphHasChanged();
        this.nl.repaint();
    }

    public double getWeight() {
        return this.weight;
    }

    public void setColor(Color color) {
        this.color = color;
        this.nl.repaint();
    }

    public Color getColor() {
        if (this.rejected) {
            return Color.MAGENTA;
        }
        return this.color;
    }

    public void addNodeListener(NodeListener l) {
        this.listener.add(l);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + " (w: " + this.getWS() + ")";
    }

    public void setName(String name) {
        this.name = name;
        TeXFormula formula = new TeXFormula("\\mathbf{" + name + "}");
        this.iconName = formula.createTeXIcon(2, (float)((int)(14.0 * this.nl.getZoom())));
        this.nl.graphHasChanged();
    }

    public boolean isRejected() {
        return this.rejected;
    }

    public void reject() {
        this.color = Color.MAGENTA;
        this.rejected = true;
    }

    public void setLocalPower(double d) {
        this.localPower = d;
    }
}

