% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gMCP.extended.R
\name{simes.test}
\alias{simes.test}
\title{Weighted Simes test}
\usage{
simes.test(pvalues, weights, alpha = 0.05, adjPValues = TRUE,
  verbose = FALSE, ...)
}
\arguments{
\item{pvalues}{A numeric vector specifying the p-values.}

\item{weights}{A numeric vector of weights.}

\item{alpha}{A numeric specifying the maximal allowed type one error rate. If \code{adjPValues==TRUE} (default) the parameter \code{alpha} is not used.}

\item{adjPValues}{Logical scalar. If \code{TRUE} (the default) an adjusted p-value for the weighted Simes test is returned.
Otherwise if \code{adjPValues==FALSE} a logical value is returned whether the null hypothesis can be rejected.}

\item{verbose}{Logical scalar. If \code{TRUE} verbose output is generated.}

\item{...}{Further arguments possibly passed by \code{gMCP} which will be used by other test procedures but not this one.}
}
\description{
Weighted Simes test introduced by Benjamini and Hochberg (1997)
}
\examples{

simes.test(pvalues=c(0.1,0.2,0.05), weights=c(0.5,0.5,0))
simes.test(pvalues=c(0.1,0.2,0.05), weights=c(0.5,0.5,0), adjPValues=FALSE)

}

