/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.graph;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.af.commons.widgets.DesktopPaneBG;
import org.af.commons.widgets.validate.RealTextField;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.CreateGraphGUI;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.dialogs.MatrixCreationDialog;
import org.af.gMCP.gui.graph.Node;
import org.af.gMCP.gui.graph.PPanel;
import org.af.gMCP.gui.graph.WrongInputException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PView
extends JPanel
implements KeyListener,
ActionListener {
    private static final Log logger = LogFactory.getLog(PView.class);
    JLabel alphaLabel = new JLabel("Total \u03b1: ");
    GridBagConstraints c = new GridBagConstraints();
    CellConstraints cc = new CellConstraints();
    JPanel correlatedPanel = null;
    JButton createMatrix;
    JButton jbLoadPValues = new JButton("Load p-values from R");
    public JComboBox jcbCorObject;
    protected JRadioButton jrbNoCorrelation = new JRadioButton("No information about correlations (Bonferroni based weighted tests)");
    public JRadioButton jrbRCorrelation = new JRadioButton("Select an R correlation matrix");
    public JRadioButton jrbSimes = new JRadioButton("Use Simes test");
    private Vector<PPanel> panels = new Vector();
    CreateGraphGUI parent;
    List<Double> pValues = null;
    List<RealTextField> entangledWeights = new Vector<RealTextField>();
    JButton refresh;
    JLabel statusLabel = new JLabel("");
    private RealTextField totalAlpha = new RealTextField("totalAlpha", 0.0, 1.0);
    JLabel weightLabel = new JLabel("Weights");
    JLabel subGraphLabel = new JLabel();

    public PView(CreateGraphGUI parent) {
        this.parent = parent;
        this.setLayout(new GridBagLayout());
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.fill = 1;
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.ipadx = 0;
        this.c.ipady = 0;
        this.totalAlpha.addKeyListener((KeyListener)this);
        this.totalAlpha.setText(Configuration.getInstance().getClassProperty(this.getClass(), "alpha level", "0.025"));
        this.setUp();
        this.jbLoadPValues.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.parent.getGraphView().setResultUpToDate(false);
        if (e.getSource() == this.refresh) {
            this.refresh(true);
        } else if (e.getSource() == this.jrbNoCorrelation) {
            if (this.parent.getGraphView().getNL().getNodes().size() > 0) {
                this.parent.getGraphView().buttonConfInt.setEnabled(true);
                this.parent.getGraphView().buttonadjPval.setEnabled(true);
            }
        } else if (e.getSource() == this.jrbRCorrelation) {
            this.parent.getGraphView().buttonConfInt.setEnabled(false);
            this.parent.getGraphView().buttonadjPval.setEnabled(true);
        } else if (e.getSource() == this.jrbSimes) {
            if (!Configuration.getInstance().getClassProperty(this.getClass(), "showSimesInfo", "yes").equals("no")) {
                JCheckBox tellMeAgain = new JCheckBox("Don't show me this info again.");
                String message = "The Simes test requires certain assumptions\n(sufficient is for example independence or positive\nregression dependence) and it's the responsibility\nof the user to check whether they are fullfilled.";
                JOptionPane.showMessageDialog(this.parent, new Object[]{message, tellMeAgain}, "Info", 1);
                if (tellMeAgain.isSelected()) {
                    Configuration.getInstance().setClassProperty(this.getClass(), "showSimesInfo", "no");
                }
            }
            this.parent.getGraphView().buttonConfInt.setEnabled(false);
            this.parent.getGraphView().buttonadjPval.setEnabled(true);
        } else if (e.getSource() == this.jbLoadPValues) {
            this.parent.getGraphView().loadPValuesFromR();
        } else if (e.getSource() == this.createMatrix) {
            if (this.parent.getGraphView().getNL().getNodes().size() < 2) {
                JOptionPane.showMessageDialog(this.parent, "Correlation makes only sense for more than one hypothesis.", "No correlation for one hypothesis", 0);
            } else {
                String obj = this.jcbCorObject.getSelectedItem().toString();
                String matrix = obj.endsWith("matrices found.") ? null : obj;
                MatrixCreationDialog mcd = new MatrixCreationDialog(this.parent, matrix, MatrixCreationDialog.getNames(this.parent.getGraphView().getNL().getNodes()));
                this.refresh(false);
                if (mcd.created) {
                    this.jrbRCorrelation.setSelected(true);
                }
            }
        }
    }

    public void addPPanel(Node node) {
        this.panels.add(new PPanel(node, this));
        this.setUp();
    }

    public JPanel getCorrelatedPanel() {
        if (this.correlatedPanel != null) {
            this.refresh(false);
            return this.correlatedPanel;
        }
        try {
            this.refresh = new JButton("Refresh", new ImageIcon(ImageIO.read(DesktopPaneBG.class.getResource("/org/af/gMCP/gui/graph/images/update24.png"))));
            this.createMatrix = new JButton("Create Matrix", new ImageIcon(ImageIO.read(DesktopPaneBG.class.getResource("/org/af/gMCP/gui/graph/images/matrix.png"))));
        }
        catch (IOException e) {
            logger.error((Object)"IOError that should never happen.", (Throwable)e);
        }
        this.refresh.setToolTipText("search again for matrices in R");
        this.createMatrix.setToolTipText("create matrix with GUI");
        this.refresh.addActionListener(this);
        this.createMatrix.addActionListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(this.jrbNoCorrelation);
        group.add(this.jrbRCorrelation);
        group.add(this.jrbSimes);
        this.jrbNoCorrelation.addActionListener(this);
        this.jrbRCorrelation.addActionListener(this);
        this.jrbSimes.addActionListener(this);
        this.correlatedPanel = new JPanel();
        this.jcbCorObject = new JComboBox<String>(new String[0]);
        this.jcbCorObject.addActionListener(this);
        this.refresh(false);
        if (!this.jrbRCorrelation.isSelected() && !this.jrbSimes.isSelected()) {
            this.jrbNoCorrelation.setSelected(true);
        }
        String cols = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu, pref, 5dlu, pref, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu";
        FormLayout layout = new FormLayout(cols, rows);
        this.correlatedPanel.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 2;
        this.correlatedPanel.add((Component)this.jrbNoCorrelation, cc.xyw(2, row, 7));
        this.correlatedPanel.add((Component)this.jrbRCorrelation, cc.xy(2, row += 2));
        this.correlatedPanel.add((Component)this.jcbCorObject, cc.xy(4, row));
        this.correlatedPanel.add((Component)this.refresh, cc.xy(6, row));
        this.correlatedPanel.add((Component)this.createMatrix, cc.xy(8, row));
        this.correlatedPanel.add((Component)this.jrbSimes, cc.xyw(2, row += 2, 7));
        return this.correlatedPanel;
    }

    public String getParameters() {
        if (this.jrbRCorrelation.isSelected() && !this.jrbRCorrelation.isEnabled()) {
            JOptionPane.showMessageDialog(this.parent, "No correlation matrix available.\nUsing Bonferroni based test.", "No correlation matrix available.", 2);
            this.jrbNoCorrelation.setSelected(true);
        }
        String param = ", test=\"Bonferroni\"";
        if (this.jrbRCorrelation.isSelected()) {
            param = ", correlation=" + this.jcbCorObject.getSelectedItem() + ", test=\"parametric\"";
        } else if (this.jrbSimes.isSelected()) {
            param = ", test=\"Simes\"";
        }
        param = param + ", upscale=" + (Configuration.getInstance().getGeneralConfig().getUpscale() ? "TRUE" : "FALSE");
        return param;
    }

    public double getPValue(Node node) {
        for (int i = this.panels.size() - 1; i >= 0; --i) {
            if (this.panels.get((int)i).node != node) continue;
            return this.panels.get((int)i).p;
        }
        throw new RuntimeException("Something happend that should never happen. Please report!");
    }

    public String getPValuesString() {
        String s = "c(";
        for (PPanel panel : this.panels) {
            s = s + panel.getP() + ", ";
        }
        return s.substring(0, s.length() - 2) + ")";
    }

    public List<Double> getPValues() {
        Vector<Double> v = new Vector<Double>();
        for (PPanel panel : this.panels) {
            v.add(panel.getP());
        }
        return v;
    }

    public double getTotalAlpha() throws Exception {
        return this.getTotalAlpha(true);
    }

    public double getTotalAlpha(boolean warn) throws Exception {
        try {
            return Double.parseDouble(this.totalAlpha.getText());
        }
        catch (NumberFormatException e) {
            if (warn) {
                String error = "Alpha " + this.totalAlpha.getText() + " is no valid number between 0 and 1.";
                JOptionPane.showMessageDialog(this.parent, error, "Error parsing alpha", 0);
                throw new WrongInputException(error);
            }
            return 0.0;
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.keyTyped(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.keyTyped(e);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.parent.getGraphView().setResultUpToDate(false);
        for (PPanel p : this.panels) {
            p.updateMe(false);
        }
    }

    public void newGraph() {
        this.panels.removeAllElements();
    }

    public void recalculate() {
        for (PPanel p : this.panels) {
            p.updateMe(true);
        }
        this.revalidate();
        this.repaint();
    }

    private void refresh(boolean showInfo) {
        this.jcbCorObject.removeAllItems();
        int dim = this.parent.getGraphView().getNL().getNodes().size();
        String[] matrices = RControl.getR().eval("gMCP:::getAllCorrelationMatrices(n=" + dim + ")").asRChar().getData();
        if (showInfo && !Configuration.getInstance().getClassProperty(this.getClass(), "showRefreshInfo", "yes").equals("no")) {
            JCheckBox tellMeAgain = new JCheckBox("Don't show me this info again.");
            int n = matrices.length == 1 && matrices[0].endsWith("matrices found.") ? 0 : matrices.length;
            String message = "Searched and found " + n + " correlation " + (n == 1 ? " matrix" : " matrices") + " of\n" + "dimension " + dim + "x" + dim + " in the R global environment.";
            JOptionPane.showMessageDialog(this.parent, new Object[]{message, tellMeAgain}, "Info", 1);
            if (tellMeAgain.isSelected()) {
                Configuration.getInstance().setClassProperty(this.getClass(), "showRefreshInfo", "no");
            }
        }
        if (matrices.length == 1 && matrices[0].endsWith("matrices found.")) {
            this.jcbCorObject.setEnabled(false);
            this.jrbRCorrelation.setEnabled(false);
        } else {
            this.jcbCorObject.setEnabled(true);
            this.jrbRCorrelation.setEnabled(true);
        }
        for (String s : matrices) {
            this.jcbCorObject.addItem(s);
        }
    }

    public void removePPanel(Node node) {
        for (int i = this.panels.size() - 1; i >= 0; --i) {
            if (this.panels.get((int)i).node != node) continue;
            this.panels.remove(i);
        }
        this.setUp();
    }

    public void renameNode(int i, String name) {
        this.panels.get((int)i).label.setText(name);
    }

    public void restorePValues() {
        String debug = "Restoring PValues: ";
        if (this.pValues != null) {
            for (int i = 0; i < this.pValues.size(); ++i) {
                if (i >= this.panels.size()) continue;
                this.panels.get(i).setP(this.pValues.get(i));
                debug = debug + Configuration.getInstance().getGeneralConfig().getDecFormat().format(this.pValues.get(i)) + "; ";
            }
        }
        logger.debug((Object)debug);
    }

    public void savePValues() {
        String debug = "Saving PValues: ";
        this.pValues = new Vector<Double>();
        for (PPanel panel : this.panels) {
            panel.keyTyped(null);
            this.pValues.add(panel.getP());
            debug = debug + Configuration.getInstance().getGeneralConfig().getDecFormat().format(panel.getP()) + "; ";
        }
        logger.debug((Object)debug);
    }

    public void setPValues(double[] pvalues) {
        this.setPValues(ArrayUtils.toObject((double[])pvalues));
    }

    public void setPValues(Double[] pvalues) {
        this.pValues = Arrays.asList(pvalues);
        this.restorePValues();
    }

    public void setTesting(boolean b) {
        Configuration.getInstance().getClassProperty(this.getClass(), this.totalAlpha.getText());
        PPanel.setTesting(b);
        for (PPanel p : this.panels) {
            p.updateMe(true);
        }
        this.totalAlpha.setEditable(!b);
        this.refresh.setEnabled(!b);
        this.createMatrix.setEnabled(!b);
        this.jrbNoCorrelation.setEnabled(!b);
        this.jrbRCorrelation.setEnabled(!b);
        this.jrbSimes.setEnabled(!b);
        this.jcbCorObject.setEnabled(!b);
        this.jbLoadPValues.setEnabled(!b);
        if (!b) {
            this.refresh(false);
        }
    }

    public void setUp() {
        JPanel panel = new JPanel();
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu";
        for (PPanel p : this.panels) {
            rows = rows + ", pref, 5dlu";
        }
        for (int i = 0; i < this.parent.getGraphView().getNumberOfLayers(); ++i) {
            cols = cols + ", fill:pref:grow, 5dlu";
        }
        if (this.parent.getGraphView().getNumberOfLayers() > 1) {
            rows = rows + ", pref, 5dlu";
        }
        FormLayout layout = new FormLayout(cols, rows);
        panel.setLayout((LayoutManager)layout);
        panel.add((Component)new JLabel("Hypothesis"), this.cc.xy(2, 2));
        panel.add((Component)this.weightLabel, this.cc.xy(4, 2));
        int col = 6;
        for (int i = 1; i < this.parent.getGraphView().getNumberOfLayers(); ++i) {
            panel.add((Component)new JLabel("Weights " + (i + 1)), this.cc.xy(col, 2));
            col += 2;
        }
        panel.add((Component)new JLabel("P-Value"), this.cc.xy(col, 2));
        int row = 4;
        for (PPanel p : this.panels) {
            int col2 = 2;
            for (Component c : p.getComponent()) {
                panel.add(c, this.cc.xy(col2, row));
                col2 += 2;
            }
            row += 2;
        }
        panel.add((Component)this.statusLabel, this.cc.xyw(2, row, col - 3));
        panel.add((Component)this.jbLoadPValues, this.cc.xy(col, row));
        panel.add((Component)this.alphaLabel, this.cc.xy(2, row += 2));
        panel.add((Component)this.totalAlpha, this.cc.xy(4, row));
        this.totalAlpha.addKeyListener((KeyListener)this);
        if (this.parent.getGraphView().getNumberOfLayers() > 1) {
            int i;
            panel.add((Component)new JLabel("Component graph weights: "), this.cc.xy(2, row += 2));
            for (i = this.entangledWeights.size(); i < this.parent.getGraphView().getNumberOfLayers(); ++i) {
                RealTextField tf = new RealTextField("totalAlpha", 0.0, 1.0);
                tf.setText("0");
                tf.addKeyListener((KeyListener)this);
                this.entangledWeights.add(tf);
            }
            col = 4;
            for (i = 0; i < this.parent.getGraphView().getNumberOfLayers(); ++i) {
                panel.add((Component)this.entangledWeights.get(i), this.cc.xy(col, row));
                col += 2;
            }
            panel.add((Component)this.subGraphLabel, this.cc.xyw(2, row += 2, 5));
        }
        this.updateLabels();
        panel.revalidate();
        this.removeAll();
        this.add((Component)panel, this.c);
        ++this.c.gridy;
        this.add((Component)this.getCorrelatedPanel(), this.c);
        this.revalidate();
    }

    public void updateLabels() {
        int i;
        this.statusLabel.setForeground(Color.BLACK);
        String text = "Sum of weights: ";
        if (this.parent.getGraphView().getNumberOfLayers() > 1) {
            text = "Subgraph sum of weights: ";
        }
        for (int i2 = 0; i2 < this.parent.getGraphView().getNumberOfLayers(); ++i2) {
            double weight = 0.0;
            for (PPanel p : this.panels) {
                if (p.rejected.booleanValue()) continue;
                weight += p.w.get(i2).doubleValue();
            }
            if (weight > 1.0001) {
                this.statusLabel.setForeground(Color.RED);
            }
            text = text + Configuration.getInstance().getGeneralConfig().getDecFormat().format(weight) + "; ";
        }
        this.statusLabel.setText(text);
        this.subGraphLabel.setForeground(Color.BLACK);
        this.subGraphLabel.setText("");
        double weight = 0.0;
        if (this.entangledWeights.size() > 0) {
            try {
                for (i = 0; i < this.entangledWeights.size(); ++i) {
                    weight += Double.parseDouble(this.entangledWeights.get(i).getText());
                }
                if (Math.abs(1.0 - weight) > 1.0E-4) {
                    this.subGraphLabel.setForeground(Color.RED);
                    this.subGraphLabel.setText("Component graph weights do not sum up to 1.");
                }
            }
            catch (NumberFormatException nfe) {
                this.subGraphLabel.setForeground(Color.RED);
                this.subGraphLabel.setText("Component graph weights could not be parsed.");
            }
        }
        for (i = 0; i < this.entangledWeights.size(); ++i) {
            this.parent.getGraphView().getNL().setEntangledLegendWeight(i, this.entangledWeights.get(i).getText());
        }
    }

    public void setEntangledWeights(double[] ew) {
        for (int i = 0; i < ew.length; ++i) {
            this.entangledWeights.get(i).setText("" + ew[i]);
        }
        this.updateLabels();
    }

    public void addEntangledLayer() {
        for (PPanel p : this.panels) {
            p.addEntangledLayer();
        }
        this.weightLabel.setText("Weights 1");
        this.setUp();
    }

    public void removeEntangledLayer(int layer) {
        for (PPanel p : this.panels) {
            p.removeEntangledLayer(layer);
        }
        if (this.parent.getGraphView().getNumberOfLayers() == 1) {
            this.weightLabel.setText("Weights");
        }
        this.setUp();
    }
}

