% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gMCP.R
\name{rejectNode}
\alias{rejectNode}
\title{Rejects a node/hypothesis and updates the graph accordingly.}
\usage{
rejectNode(graph, node, upscale = FALSE, verbose = FALSE, keepWeights = FALSE)
}
\arguments{
\item{graph}{A graph of class \code{graphMCP} or \code{entangledMCP}.}

\item{node}{A character string specifying the node to reject.}

\item{upscale}{Logical. If \code{upscale=TRUE} then the weights of all non-rejected
nodes are scaled so that the sum is equal to 1. This forces \code{keepWeights=FALSE}
to reduce confusion, since otherwise the sum of weights could become bigger than 1.}

\item{verbose}{Logical scalar.  If \code{TRUE} verbose output is generated
during sequentially rejection steps.}

\item{keepWeights}{Logical scalar. If \code{FALSE} the weight of a node
without outgoing edges is set to 0 if it is removed.  Otherwise it keeps its
weight.}
}
\value{
An updated graph of class \code{graphMCP} or \code{entangledMCP}.
}
\description{
Rejects a node/hypothesis and updates the graph accordingly.
}
\details{
For details see the given references.
}
\examples{
m <- matrix(0, nrow = 4, ncol = 4)
m[1,3] <- m[2,4] <- m[3,2] <- m[4,1] <- 1
p1 <- c(0.01, 0.005, 0.01, 0.5)
a <- 0.05
w <- c(1/2, 1/2, 0, 0)
g <- matrix2graph(m, w)
gMCP(g, pvalues=p1, alpha=a)
rejectNode(graph = g, node = 4)


}
\references{
Frank Bretz, Willi Maurer, Werner Brannath, Martin Posch: A
graphical approach to sequentially rejective multiple test procedures.
Statistics in Medicine 2009 vol. 28 issue 4 page 586-604.
\url{https://www.meduniwien.ac.at/fwf_adaptive/papers/bretz_2009_22.pdf}
}
\seealso{
\code{graphMCP}
}
\author{
Kornelius Rohmeyer \email{rohmeyer@small-projects.de}
}
\keyword{graphs}
\keyword{htest}
