\name{gconvert}
\alias{gconvert}
\title{Convert gene IDs.}
\usage{gconvert(query, organism="hsapiens", target="ENSG", region_query=F,
    numeric_ns="", mthreshold=Inf, filter_na=T, df=T)
}
\description{Convert gene IDs.}
\details{Interface to the g:Convert tool. Organism names are constructed by
concatenating the first letter of the name and the family name. Example: human
- 'hsapiens', mouse - 'mmusculus'.}
\value{The output can be either a list or a data.frame. The list has an entry
for every input gene. The data frame is a table closely corresponding to the
web interface output.}
\references{J. Reimand, M. Kull, H. Peterson, J.  Hansen, J. Vilo: g:Profiler
- a web-based toolset for functional profiling of gene lists from large-scale
experiments (2007) NAR 35 W193-W200}
\author{Juri Reimand <jyri.reimand@ut.ee>, Raivo Kolde <rkolde@gmail.com>,
Tambet Arak <tambet.arak@gmail.com>}
\arguments{\item{query}{list of gene IDs.}
\item{organism}{organism name.}
\item{target}{target namespace.}
\item{region_query}{interpret query as chromosomal ranges.}
\item{numeric_ns}{namespace to use for fully numeric IDs.}
\item{mthreshold}{maximum number of results per initial alias to show.}
\item{filter_na}{logical indicating whether to filter out results without a
corresponding target.}
\item{df}{logical indicating whether the output will be a data.frame or list.}
}
\examples{gconvert(c("POU5F1", "SOX2", "NANOG"), organism = "hsapiens", target="AFFY_HG_U133_PLUS_2")}

