% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evi.R
\name{grain-evi}
\alias{grain-evi}
\alias{setEvi}
\alias{setEvi_}
\alias{retractEvi}
\alias{retractEvi_}
\alias{absorbEvi}
\alias{absorbEvi_}
\alias{pEvidence}
\alias{pEvi}
\alias{getEvidence}
\alias{dropEvi<-}
\alias{addEvi<-}
\alias{evidence}
\alias{evidence.grain}
\alias{evidence<-}
\alias{evidence<-.grain}
\alias{addEvi}
\alias{dropEvi}
\alias{getEvi}
\alias{insertEvi}
\alias{getHostClique}
\title{Set evidence in grain objects}
\usage{
setEvi(
  object,
  nodes = NULL,
  states = NULL,
  evidence = NULL,
  propagate = TRUE,
  details = 0
)

setEvi_(object, evidence = NULL, propagate = TRUE, details = 0)

retractEvi(object, items = NULL, propagate = TRUE)

retractEvi_(object, items = NULL, propagate = TRUE)

absorbEvi(object, propagate = TRUE)

absorbEvi_(object, propagate = TRUE)

pEvidence(object)

pEvi(object)

getEvidence(object)

dropEvi(object) <- value

addEvi(object) <- value

evidence(object)

\method{evidence}{grain}(object)

evidence(object) <- value

\method{evidence}{grain}(object) <- value

addEvi(
  object,
  nodes = NULL,
  states = NULL,
  evidence = NULL,
  propagate = TRUE,
  details = 0
)

dropEvi(object, items = NULL, propagate = TRUE)

getEvi(object)

insertEvi(evi.list, pot, hostclique)

getHostClique(set.list, cliques)
}
\arguments{
\item{object}{A "grain" object}

\item{nodes}{A vector of nodes; those nodes for which the
(conditional) distribution is requested.}

\item{states}{A vector of states (of the nodes given by 'nodes')}

\item{evidence}{An alternative way of specifying findings
(evidence), see examples below.}

\item{propagate}{Should the network be propagated?}

\item{details}{Debugging information}

\item{items}{Items in the evidence list to be removed. Here,
\code{NULL} means remove everything. If \code{items} is a
character vector (of nodes) then evidence on these nodes is
removed. If \code{items} is a numeric vector then those items
in the evidence list is removed. Notice that \code{0} means nothing is
removed.}

\item{value}{The evidence in the form of a named list or an evidence-object.}

\item{evi.list}{A "grain_ev" object.}

\item{pot}{A list of clique potentials (a potential is an array).}

\item{hostclique}{A numerical vector indicating in which element of
'pot' each eviendence item in 'evi.list' should be inserted in.}

\item{set.list}{A list of sets (a set is a character vector).}

\item{cliques}{A list of sets (a set is a character vector).}
}
\description{
Setting and removing evidence in grain objects.
}
\examples{

## setFinding / setEvidence

yn <- c("yes","no")
a    <- cptable(~asia, values=c(1,99),levels=yn)
t.a  <- cptable(~tub+asia, values=c(5,95,1,99),levels=yn)
s    <- cptable(~smoke, values=c(5,5), levels=yn)
l.s  <- cptable(~lung+smoke, values=c(1,9,1,99), levels=yn)
b.s  <- cptable(~bronc+smoke, values=c(6,4,3,7), levels=yn)
e.lt <- cptable(~either+lung+tub,values=c(1,0,1,0,1,0,0,1),levels=yn)
x.e  <- cptable(~xray+either, values=c(98,2,5,95), levels=yn)
d.be <- cptable(~dysp+bronc+either, values=c(9,1,7,3,8,2,1,9), levels=yn)
plist <- compileCPT(list(a, t.a, s, l.s, b.s, e.lt, x.e, d.be))
bn <- grain(plist)
 
## 1) These forms are identical

e1 <- list(dysp="no", xray="no")

setEvi(bn, evidence=e1)
setEvi(bn, nodes=c("dysp","xray"), states=c("no", "no"))
setEvidence(bn, nodes=c("dysp","xray"), states=c("no", "no"))

# Notice: setFinding is old school but it was used in the
# "Graphical Models with R" book.
setFinding(bn, nodes=c("dysp","xray"), states=c("no", "no"))

## 2) Updating evidence
# Notice that only 'asia' is set because 'dysp' was set earlier

e2 <- list(dysp="yes", asia="yes")
bn1 <- setEvi(bn, evidence=e1)
bn1
bn2 <- setEvi(bn1, evidence=e2)
bn2

## 3) Shorter forms

bn2 <- bn
evidence(bn2)
evidence(bn2) <- e1
evidence(bn2)
evidence(bn2) <- e2
evidence(bn2)
evidence(bn2) <- NULL
evidence(bn2)


## 4) Alternative forms:

setEvi(bn, evidence=list("asia"=c(1, 0), "xray"="yes"))

## 5) Suppose we do not know with certainty whether a patient has
## recently been to Asia. We can then introduce a new variable
## "guess.asia" with "asia" as its only parent. Suppose
## p(guess.asia=yes|asia=yes)=.8 and p(guess.asia=yes|asia=no)=.1
## If the patient is e.g. unusually tanned we may set
## guess.asia=yes and propagate. This corresponds to modifying the
## model by the likelihood (0.8, 0.1) as

b =setEvi(bn, nodes=c("asia","xray"), states=list(c(0.8,0.1), "yes"))
as.data.frame( evidence( b ) )

}
\references{
Søren Højsgaard (2012). Graphical Independence Networks
with the gRain Package for R. Journal of Statistical Software,
46(10), 1-26.  \url{http://www.jstatsoft.org/v46/i10/}.
}
\seealso{
\code{\link{setEvidence}}, \code{\link{getEvidence}},
\code{\link{retractEvidence}}, \code{\link{pEvidence}},
\code{\link{setFinding}}, \code{\link{getFinding}},
\code{\link{retractFinding}}, \code{\link{pFinding}},
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{models}
\keyword{utilities}
