% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grain_data.R
\docType{data}
\name{grass}
\alias{grass}
\alias{grass_cpt}
\title{Wet grass example}
\format{
An object of class \code{list} of length 3.
}
\usage{
data(grass_cpt)
}
\description{
Conditional probability tables for the wet grass example.
}
\examples{

## 'data' generated with the following code fragment
yn <- c("yes", "no")
p.R    <- cptable(~R, values=c(.2, .8), levels=yn)
p.S_R  <- cptable(~S:R, values=c(.01, .99, .4, .6), levels=yn)
p.G_SR <- cptable(~G:S:R, values=c(.99, .01, .8, .2, .9, .1, 0, 1), levels=yn)

grain(compileCPT(p.R, p.S_R, p.G_SR))

# 'data' generated from
grass_cpt <- list(p.R, p.S_R, p.G_SR)

data(grass_cpt)

}
\keyword{datasets}
