% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.R
\name{select.data_request}
\alias{select.data_request}
\title{Specify fields for occurrence download}
\usage{
\method{select}{data_request}(.data, ..., group = c("basic", "event", "media", "assertions"))
}
\arguments{
\item{.data}{An object of class \code{data_request}, created using \code{\link[=galah_call]{galah_call()}}}

\item{...}{zero or more individual column names to include}

\item{group}{\code{string}: (optional) name of one or more column groups to
include. Valid options are \code{"basic"}, \code{"event"} and
\code{"assertions"}}
}
\value{
A tibble
specifying the name and type of each column to include in the
call to \code{atlas_counts()} or \code{atlas_occurrences()}.
}
\description{
The living atlases store content in hundreds of different fields, and users
often require thousands or millions of records at a time. To reduce time taken
to download data, and limit complexity of the resulting \code{data.frame}, it is
sensible to restrict the fields returned by \code{\link[=atlas_occurrences]{atlas_occurrences()}}.
This function allows easy selection of fields, or commonly-requested groups
of columns, following syntax shared with \code{dplyr::select()}.
}
\details{
The full list of available fields can be viewed with \code{show_all(fields)}.
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Calling the argument \code{group = "basic"} returns the following columns:
\itemize{
\item \code{decimalLatitude}
\item \code{decimalLongitude}
\item \code{eventDate}
\item \code{scientificName}
\item \code{taxonConceptID}
\item \code{recordID}
\item \code{dataResourceName}
\item \code{occurrenceStatus}
}

Using \code{group = "event"} returns the following columns:
\itemize{
\item \code{eventRemarks}
\item \code{eventTime}
\item \code{eventID}
\item \code{eventDate}
\item \code{samplingEffort}
\item \code{samplingProtocol}
}

Using \code{group = "media"} returns the following columns:
\itemize{
\item \code{multimedia}
\item \code{multimediaLicence}
\item \code{images}
\item \code{videos}
\item \code{sounds}
}

Using \code{group = "assertions"} returns all quality assertion-related
columns. The list of assertions is shown by \code{show_all_assertions()}.
}
\seealso{
\code{\link[=galah_select]{galah_select()}}, with which this function is synonymous.
}
