% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLik.galamm.R
\name{deviance.galamm}
\alias{deviance.galamm}
\title{Extract deviance of galamm object}
\usage{
\method{deviance}{galamm}(object, ...)
}
\arguments{
\item{object}{Object of class \code{galamm}, returned from
\code{\link{galamm}}.}

\item{...}{Other arguments passed on to other methods. Currently not used.}
}
\value{
A numeric value giving the deviance of the model fit.
}
\description{
Extract deviance of galamm object
}
\examples{
# Linear mixed model with heteroscedastic residuals
mod <- galamm(
  formula = y ~ x + (1 | id),
  weights = ~ (1 | item),
  data = hsced
)

# Extract deviance
deviance(mod)

}
\seealso{
\code{\link[=logLik.galamm]{logLik.galamm()}} for a function returning the log likelihood and
\code{\link[=deviance]{deviance()}} for the generic function.

Other details of model fit: 
\code{\link{VarCorr}()},
\code{\link{coef.galamm}()},
\code{\link{confint.galamm}()},
\code{\link{factor_loadings.galamm}()},
\code{\link{family.galamm}()},
\code{\link{fitted.galamm}()},
\code{\link{fixef}()},
\code{\link{formula.galamm}()},
\code{\link{llikAIC}()},
\code{\link{logLik.galamm}()},
\code{\link{nobs.galamm}()},
\code{\link{predict.galamm}()},
\code{\link{print.VarCorr.galamm}()},
\code{\link{ranef.galamm}()},
\code{\link{residuals.galamm}()},
\code{\link{sigma.galamm}()},
\code{\link{vcov.galamm}()}
}
\concept{details of model fit}
