% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/got_palette.R
\name{gotMap}
\alias{gotMap}
\alias{got}
\alias{got_pal}
\alias{gameofthrones}
\title{Game of Thrones Colour Map.}
\usage{
gotMap(n = 256, alpha = 1, begin = 0, end = 1, direction = 1,
  option = "targaryen")

got(n, alpha = 1, begin = 0, end = 1, direction = 1,
  option = "targaryen")

got_pal(alpha = 1, begin = 0, end = 1, direction = 1,
  option = "targaryen")

gameofthrones(n, alpha = 1, begin = 0, end = 1, direction = 1,
  option = "targaryen")
}
\arguments{
\item{n}{The number of colors (\eqn{\ge 1}) to be in the palette.}

\item{alpha}{The alpha transparency, a number in [0,1], see argument alpha in
\code{\link[grDevices]{hsv}}.}

\item{begin}{The (corrected) hue in [0,1] at which the got colormap begins.}

\item{end}{The (corrected) hue in [0,1] at which the got colormap ends.}

\item{direction}{Sets the order of colors in the scale. If 1, the default, colors
are ordered from darkest to lightest. If -1, the order of colors is reversed.}

\item{option}{A character string indicating the colourmap to use. It is not case-sensible}
}
\value{
\code{got} returns a character vector, \code{cv}, of color hex
codes. This can be used either to create a user-defined color palette for
subsequent graphics by \code{palette(cv)}, a \code{col =} specification in
graphics functions or in \code{par}.

\code{gotMap} returns a \code{n} lines data frame containing the
red (\code{R}), green (\code{G}), blue (\code{B}) and alpha (\code{alpha})
channels of \code{n} equally spaced colors along the 'Game of Thrones' colour map.
\code{n = 256} by default.
}
\description{
This function creates a vector of \code{n} equally spaced colors along the
'got colour map'.
}
\details{
\if{html}{Here are the color scales:

  \out{<div style="text-align: center">}\figure{got-scales.png}{houses: style="width:750px;max-width:90\%;"}\out{</div>}

  }
\if{latex}{Here are the color scales:

  \out{\begin{center}}\figure{got-scales.png}\out{\end{center}}
  }


Semi-transparent colors (\eqn{0 < alpha < 1}) are supported only on some
devices: see \code{\link[grDevices]{rgb}}.
}
\examples{
library(ggplot2)
library(hexbin)

dat <- data.frame(x = rnorm(1e4), y = rnorm(1e4))

ggplot(dat, aes(x = x, y = y)) +
  geom_hex() + coord_fixed() +
  scale_fill_gradientn(colours = got(128, option = "targaryen")) +
  theme_minimal()

pal <- got(256, option = "Wildfire")
image(volcano, col = pal)

}
\author{
Alejandro Jiménez Rico \email{aljrico@gmail.com}, \href{https://aljrico.github.io}{Personal Blog}
}
