# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Write a data source to file
#'
#' Write a data source including settings of active columns to a file in binary format.
#' This file will be used as input in functions for generation of generative data.\cr
#'
#' @param fileName Name of data source file
#'
#' @return None
#' @export
#'
#' @examples
#' \dontrun{
#' dsCreateWithDataFrame(iris)
#' dsDeactivateColumns(c(5))
#' dsWrite("ds.bin")}
dsWrite <- function(fileName) {
    invisible(.Call('_ganGenerativeData_dsWrite', PACKAGE = 'ganGenerativeData', fileName))
}

#' Read a data source from file
#'
#' Read a data source from a file in binary format
#'
#' @param fileName Name of data source file
#'
#' @return None
#' @export
#'
#' @examples
#' \dontrun{
#' dsCreateWithDataFrame(iris)
#' dsDeactivateColumns(c(5))
#' dsWrite("ds.bin")
#' dsRead("ds.bin")}
dsRead <- function(fileName) {
    invisible(.Call('_ganGenerativeData_dsRead', PACKAGE = 'ganGenerativeData', fileName))
}

dsCreate <- function(columnTypes, columnNames) {
    invisible(.Call('_ganGenerativeData_dsCreate', PACKAGE = 'ganGenerativeData', columnTypes, columnNames))
}

dsAddValueRow <- function(valueVector) {
    invisible(.Call('_ganGenerativeData_dsAddValueRow', PACKAGE = 'ganGenerativeData', valueVector))
}

#' Deactivate columns
#'
#' Deactivate columns in a data source in order to exclude them from training
#' of generative models. Note that the training function in the package
#' supports only columns of type R-class numeric, R-type double. All columns of
#' other type have to be deactivated. The training function in the software
#' service for accelerated training of generative models supports columns of
#' any type.
#'
#' @param columnVector Vector of column indices
#'
#' @return None
#' @export
#'
#' @examples
#' \donttest{
#' dsCreateWithDataFrame(iris)
#' dsDeactivateColumns(c(5))
#' dsGetInactiveColumnNames()}
dsDeactivateColumns <- function(columnVector) {
    invisible(.Call('_ganGenerativeData_dsDeactivateColumns', PACKAGE = 'ganGenerativeData', columnVector))
}

#' Activate columns
#'
#' Activate columns in a data source in order to include them in training of generative models. By default columns are active.
#'
#' @param columnVector Vector of column indices
#'
#' @return None
#' @export
#'
#' @examples
#' \donttest{
#' dsCreateWithDataFrame(iris)
#' dsGetActiveColumnNames()
#' dsDeactivateColumns(c(5))
#' dsGetActiveColumnNames()
#' dsActivateColumns(c(5))
#' dsGetActiveColumnNames()}
dsActivateColumns <- function(columnVector) {
    invisible(.Call('_ganGenerativeData_dsActivateColumns', PACKAGE = 'ganGenerativeData', columnVector))
}

#' Get active column names
#'
#' Get active column names of a data source
#'
#' @return Vector of names of active columns
#' @export
#'
#' @examples
#' \donttest{
#' dsCreateWithDataFrame(iris)
#' dsDeactivateColumns(c(5))
#' dsGetActiveColumnNames()}
dsGetActiveColumnNames <- function() {
    .Call('_ganGenerativeData_dsGetActiveColumnNames', PACKAGE = 'ganGenerativeData')
}

#' Get inactive column names
#'
#' Get inactive column names of a data source
#'
#' 
#'
#' @return Vector of names of inactive columns
#' @export
#'
#' @examples
#' \donttest{
#' dsCreateWithDataFrame(iris)
#' dsDeactivateColumns(c(5))
#' dsGetInactiveColumnNames()}
dsGetInactiveColumnNames <- function() {
    .Call('_ganGenerativeData_dsGetInactiveColumnNames', PACKAGE = 'ganGenerativeData')
}

#' Get number of rows
#'
#' Get number of rows in a data source
#'
#' 
#'
#' @return Number of rows
#' @export
#'
#' @examples
#' \donttest{
#' dsCreateWithDataFrame(iris)
#' dsGetNumberOfRows()}
dsGetNumberOfRows <- function() {
    .Call('_ganGenerativeData_dsGetNumberOfRows', PACKAGE = 'ganGenerativeData')
}

#' Get a row in a data source
#'
#' Get a row in a data source for a row index.
#'
#' @param index Index of row
#'
#' @return List containing row in data source
#' @export
#'
#' @examples
#' \donttest{
#' dsCreateWithDataFrame(iris)
#' dsGetRow(1)}
dsGetRow <- function(index) {
    .Call('_ganGenerativeData_dsGetRow', PACKAGE = 'ganGenerativeData', index)
}

dsGetNormalized <- function() {
    .Call('_ganGenerativeData_dsGetNormalized', PACKAGE = 'ganGenerativeData')
}

gdReset <- function() {
    invisible(.Call('_ganGenerativeData_gdReset', PACKAGE = 'ganGenerativeData'))
}

gdGetDataSourceFileName <- function() {
    .Call('_ganGenerativeData_gdGetDataSourceFileName', PACKAGE = 'ganGenerativeData')
}

gdGetGenerativeDataFileName <- function() {
    .Call('_ganGenerativeData_gdGetGenerativeDataFileName', PACKAGE = 'ganGenerativeData')
}

gdGetBatchSize <- function() {
    .Call('_ganGenerativeData_gdGetBatchSize', PACKAGE = 'ganGenerativeData')
}

gdGetMaxSize <- function() {
    .Call('_ganGenerativeData_gdGetMaxSize', PACKAGE = 'ganGenerativeData')
}

gdGetFileName <- function(fileName) {
    .Call('_ganGenerativeData_gdGetFileName', PACKAGE = 'ganGenerativeData', fileName)
}

gdCreateGenerativeModel <- function() {
    invisible(.Call('_ganGenerativeData_gdCreateGenerativeModel', PACKAGE = 'ganGenerativeData'))
}

gdWriteWithReadingTrainedModel <- function(outFileName) {
    invisible(.Call('_ganGenerativeData_gdWriteWithReadingTrainedModel', PACKAGE = 'ganGenerativeData', outFileName))
}

gdReadGenerativeModel <- function(inFileName) {
    .Call('_ganGenerativeData_gdReadGenerativeModel', PACKAGE = 'ganGenerativeData', inFileName)
}

gdDataSourceRead <- function(inFileName) {
    invisible(.Call('_ganGenerativeData_gdDataSourceRead', PACKAGE = 'ganGenerativeData', inFileName))
}

gdGenerativeDataRead <- function(inFileName) {
    .Call('_ganGenerativeData_gdGenerativeDataRead', PACKAGE = 'ganGenerativeData', inFileName)
}

gdGenerativeDataWrite <- function(outFileName) {
    invisible(.Call('_ganGenerativeData_gdGenerativeDataWrite', PACKAGE = 'ganGenerativeData', outFileName))
}

#' Write subset of generative data
#'
#' Write subset of randomly selected rows of generative data
#'
#' @param fileName Name of subset generative data file
#' @param percent Percent of randomly selected rows
#'
#' @return None
#' @export
#'
#' @examples
#' \dontrun{
#' gdRead("gd.bin")
#' gdWriteSubset("gds.bin", 50)}
gdWriteSubset <- function(fileName, percent) {
    invisible(.Call('_ganGenerativeData_gdWriteSubset', PACKAGE = 'ganGenerativeData', fileName, percent))
}

gdCreateGenerativeData <- function() {
    invisible(.Call('_ganGenerativeData_gdCreateGenerativeData', PACKAGE = 'ganGenerativeData'))
}

gdCreateDataSourceFromGenerativeModel <- function() {
    invisible(.Call('_ganGenerativeData_gdCreateDataSourceFromGenerativeModel', PACKAGE = 'ganGenerativeData'))
}

gdDataSourceGetDataRandom <- function(rowCount) {
    .Call('_ganGenerativeData_gdDataSourceGetDataRandom', PACKAGE = 'ganGenerativeData', rowCount)
}

gdDataSourceGetNormalizedDataRandom <- function(rowCount) {
    .Call('_ganGenerativeData_gdDataSourceGetNormalizedDataRandom', PACKAGE = 'ganGenerativeData', rowCount)
}

gdDataSourceGetNormalizedDataRandomReference <- function(rowCount) {
    .Call('_ganGenerativeData_gdDataSourceGetNormalizedDataRandomReference', PACKAGE = 'ganGenerativeData', rowCount)
}

gdDataSourceGetDataRandomPercent <- function(percent) {
    .Call('_ganGenerativeData_gdDataSourceGetDataRandomPercent', PACKAGE = 'ganGenerativeData', percent)
}

gdGenerativeDataGetDenormalizedDataRandom <- function(percent) {
    .Call('_ganGenerativeData_gdGenerativeDataGetDenormalizedDataRandom', PACKAGE = 'ganGenerativeData', percent)
}

gdGenerativeDataGetDenormalizedDataRandomWithDensities <- function(percent) {
    .Call('_ganGenerativeData_gdGenerativeDataGetDenormalizedDataRandomWithDensities', PACKAGE = 'ganGenerativeData', percent)
}

gdGetDataSourceDimension <- function() {
    .Call('_ganGenerativeData_gdGetDataSourceDimension', PACKAGE = 'ganGenerativeData')
}

gdAddValueRows <- function(valueRows) {
    invisible(.Call('_ganGenerativeData_gdAddValueRows', PACKAGE = 'ganGenerativeData', valueRows))
}

#' Get number of rows
#'
#' Get number of rows in generative data
#'
#' @return Number of rows
#' @export
#'
#' @examples
#' \dontrun{
#' gdRead("gd.bin")
#' gdGetNumberOfRows()}
gdGetNumberOfRows <- function() {
    .Call('_ganGenerativeData_gdGetNumberOfRows', PACKAGE = 'ganGenerativeData')
}

gdGetColumnNames <- function(indexVector) {
    .Call('_ganGenerativeData_gdGetColumnNames', PACKAGE = 'ganGenerativeData', indexVector)
}

gdGetGenerativeDataDimension <- function() {
    .Call('_ganGenerativeData_gdGetGenerativeDataDimension', PACKAGE = 'ganGenerativeData')
}

gdGetNumberVectorIndexNames <- function(numberVectorIndices) {
    .Call('_ganGenerativeData_gdGetNumberVectorIndexNames', PACKAGE = 'ganGenerativeData', numberVectorIndices)
}

#' Get a row in generative data
#'
#' Get a row in generative data for a row index
#'
#' @param index Index of row
#'
#' @return List containing row in generative data
#' @export
#'
#' @examples
#' \dontrun{
#' gdRead("gd.bin")
#' gdGetRow(1000)}
gdGetRow <- function(index) {
    .Call('_ganGenerativeData_gdGetRow', PACKAGE = 'ganGenerativeData', index)
}

gdGetMax <- function(i) {
    .Call('_ganGenerativeData_gdGetMax', PACKAGE = 'ganGenerativeData', i)
}

gdGetMin <- function(i) {
    .Call('_ganGenerativeData_gdGetMin', PACKAGE = 'ganGenerativeData', i)
}

gdResetDensitiyValues <- function() {
    invisible(.Call('_ganGenerativeData_gdResetDensitiyValues', PACKAGE = 'ganGenerativeData'))
}

gdIntCalculateDensityValues <- function() {
    invisible(.Call('_ganGenerativeData_gdIntCalculateDensityValues', PACKAGE = 'ganGenerativeData'))
}

#' Calculate density value for a data record
#' 
#' Calculate density value for a data record.
#' By default for the calculation a linear search is performed on generative data.
#' When a search tree is used search is performed on a tree for generative data
#' which is built once in the first function call.
#'
#' @param dataRecord List containing a data record
#' @param useSearchTree Boolean value indicating if a search tree should be used.
#'
#' @return Normalized density value number
#' @export
#'
#' @examples
#' \dontrun{
#' gdRead("gd.bin")
#' gdCalculateDensityValue(list(6.1, 2.6, 5.6, 1.4))}
gdCalculateDensityValue <- function(dataRecord, useSearchTree = FALSE) {
    .Call('_ganGenerativeData_gdCalculateDensityValue', PACKAGE = 'ganGenerativeData', dataRecord, useSearchTree)
}

#' Calculate density value quantile
#' 
#' Calculate density value quantile for a percent value. 
#'
#' @param percent Percent value
#'
#' @return Normalized density value quantile number
#' @export
#'
#' @examples
#' \dontrun{
#' gdRead("gd.bin")
#' gdCalculateDensityValueQuantile(50)}
gdCalculateDensityValueQuantile <- function(percent) {
    .Call('_ganGenerativeData_gdCalculateDensityValueQuantile', PACKAGE = 'ganGenerativeData', percent)
}

gdBuildFileName <- function(fileName, niveau) {
    .Call('_ganGenerativeData_gdBuildFileName', PACKAGE = 'ganGenerativeData', fileName, niveau)
}

#' Search for k nearest neighbors
#' 
#' Search for k nearest neighbors in generative data for a data record.
#' When the data record contains NA values only the non-NA values are considered in search.
#' By default a linear search is performed. When a search tree is used search is performed on a tree
#' which is built once in the first function call.
#' Building a tree is also triggered when NA values in data records change in subsequent function calls. 
#' 
#' @param dataRecord List containing a data record
#' @param k Number of nearest neighbors
#' @param useSearchTree Boolean value indicating if a search tree should be used. 
#'
#' @return A list of rows in generative data
#' @export
#'
#' @examples
#' \dontrun{
#' gdRead("gd.bin")
#' gdKNearestNeighbors(list(5.1, 3.5, 1.4, 0.2), 3)}
gdKNearestNeighbors <- function(dataRecord, k = 1L, useSearchTree = FALSE) {
    .Call('_ganGenerativeData_gdKNearestNeighbors', PACKAGE = 'ganGenerativeData', dataRecord, k, useSearchTree)
}

#' Complete incomplete data record
#' 
#' Search for first nearest neighbor in generative data for incomplete data record containing NA values.
#' Found row in generative data is then used to replace NA values in inccomplete data record. This function calls
#' gdKNearestNeighbors() with parameter k equal to 1.
#' 
#' @param dataRecord List containing incomplete data record
#' @param useSearchTree Boolean value indicating if a search tree should be used.
#'
#' @return List containing completed data record
#' @export
#'
#' @examples
#' \dontrun{
#' gdRead("gd.bin")
#' gdComplete(list(5.1, 3.5, 1.4, NA))}
gdComplete <- function(dataRecord, useSearchTree = FALSE) {
    .Call('_ganGenerativeData_gdComplete', PACKAGE = 'ganGenerativeData', dataRecord, useSearchTree)
}

gdGenerativeModelGetNumberOfTrainingIterations <- function() {
    .Call('_ganGenerativeData_gdGenerativeModelGetNumberOfTrainingIterations', PACKAGE = 'ganGenerativeData')
}

gdGenerativeModelSetNumberOfTrainingIterations <- function(numberOfTrainingIterations) {
    invisible(.Call('_ganGenerativeData_gdGenerativeModelSetNumberOfTrainingIterations', PACKAGE = 'ganGenerativeData', numberOfTrainingIterations))
}

gdGenerativeModelGetNumberOfInitializationIterations <- function() {
    .Call('_ganGenerativeData_gdGenerativeModelGetNumberOfInitializationIterations', PACKAGE = 'ganGenerativeData')
}

gdGenerativeModelSetNumberOfInitializationIterations <- function(numberOfInitializationIterations) {
    invisible(.Call('_ganGenerativeData_gdGenerativeModelSetNumberOfInitializationIterations', PACKAGE = 'ganGenerativeData', numberOfInitializationIterations))
}

gdGenerativeModelGetNumberOfHiddenLayerUnits <- function() {
    .Call('_ganGenerativeData_gdGenerativeModelGetNumberOfHiddenLayerUnits', PACKAGE = 'ganGenerativeData')
}

gdGenerativeModelSetNumberOfHiddenLayerUnits <- function(numberOfHiddenLayerUnits) {
    invisible(.Call('_ganGenerativeData_gdGenerativeModelSetNumberOfHiddenLayerUnits', PACKAGE = 'ganGenerativeData', numberOfHiddenLayerUnits))
}

gdGenerativeModelGetLearningRate <- function() {
    .Call('_ganGenerativeData_gdGenerativeModelGetLearningRate', PACKAGE = 'ganGenerativeData')
}

gdGenerativeModelSetLearningRate <- function(learningRate) {
    invisible(.Call('_ganGenerativeData_gdGenerativeModelSetLearningRate', PACKAGE = 'ganGenerativeData', learningRate))
}

gdGenerativeModelGetDropout <- function() {
    .Call('_ganGenerativeData_gdGenerativeModelGetDropout', PACKAGE = 'ganGenerativeData')
}

gdGenerativeModelSetDropout <- function(dropout) {
    invisible(.Call('_ganGenerativeData_gdGenerativeModelSetDropout', PACKAGE = 'ganGenerativeData', dropout))
}

gdDataSourceHasActiveStringColumn <- function() {
    .Call('_ganGenerativeData_gdDataSourceHasActiveStringColumn', PACKAGE = 'ganGenerativeData')
}

