% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsnip-garch_reg.R
\name{garch_reg}
\alias{garch_reg}
\title{General Interface for GARCH Models}
\usage{
garch_reg(
  mode = "regression",
  arch_order = NULL,
  garch_order = NULL,
  ar_order = NULL,
  ma_order = NULL
)
}
\arguments{
\item{mode}{A single character string for the type of model.}

\item{arch_order}{An integer giving the order of the ARCH part for the variance model. Applies to both garch and rugarch engines.}

\item{garch_order}{An integer giving the order of the GARCH part for the variance model. Applies to both garch and rugarch engines.}

\item{ar_order}{An integer giving the order of the AR part for the mean model. Only applies to rugarch engine.}

\item{ma_order}{An integer giving the order of the MA part for the mean model. Only applies to rugarch engine.

These arguments are converted to their specific names at the
time that the model is fit.

Other options and argument can be
set using \code{set_engine()} (See Engine Details below).}
}
\value{
A model specification
}
\description{
General Interface for GARCH Models
}
\details{
Available engines:
\itemize{
\item \strong{rugarch}: Connects to \code{rugarch::ugarchspec()} first and then to \code{rugarch::ugarchfit()}.
}
}
\section{Engine Details}{


\strong{rugarch (default)}

The engine uses \code{\link[rugarch:ugarchspec-methods]{rugarch::ugarchspec()}} and \code{\link[rugarch:ugarchfit-methods]{rugarch::ugarchfit()}}.

Function Parameters:\preformatted{## Formal class 'standardGeneric' [package "methods"] with 8 slots
##   ..@ .Data     :function (variance.model = list(model = "sGARCH", garchOrder = c(1, 1), 
##     submodel = NULL, external.regressors = NULL, variance.targeting = FALSE), 
##     mean.model = list(armaOrder = c(1, 1), include.mean = TRUE, archm = FALSE, 
##         archpow = 1, arfima = FALSE, external.regressors = NULL, archex = FALSE), 
##     distribution.model = "norm", start.pars = list(), fixed.pars = list(), 
##     ...)  
##   ..@ generic   : chr "ugarchspec"
##   .. ..- attr(*, "package")= chr "rugarch"
##   ..@ package   : chr "rugarch"
##   ..@ group     : list()
##   ..@ valueClass: chr(0) 
##   ..@ signature : chr [1:5] "variance.model" "mean.model" "distribution.model" "start.pars" ...
##   ..@ default   :Formal class 'derivedDefaultMethod' [package "methods"] with 4 slots
##   .. .. ..@ .Data  :function (variance.model = list(model = "sGARCH", garchOrder = c(1, 1), 
##     submodel = NULL, external.regressors = NULL, variance.targeting = FALSE), 
##     mean.model = list(armaOrder = c(1, 1), include.mean = TRUE, archm = FALSE, 
##         archpow = 1, arfima = FALSE, external.regressors = NULL, archex = FALSE), 
##     distribution.model = "norm", start.pars = list(), fixed.pars = list(), 
##     ...)  
##   .. .. ..@ target :Formal class 'signature' [package "methods"] with 3 slots
##   .. .. .. .. ..@ .Data  : chr "ANY"
##   .. .. .. .. ..@ names  : chr "variance.model"
##   .. .. .. .. ..@ package: chr "methods"
##   .. .. ..@ defined:Formal class 'signature' [package "methods"] with 3 slots
##   .. .. .. .. ..@ .Data  : chr "ANY"
##   .. .. .. .. ..@ names  : chr "variance.model"
##   .. .. .. .. ..@ package: chr "methods"
##   .. .. ..@ generic: chr "ugarchspec"
##   .. .. .. ..- attr(*, "package")= chr "rugarch"
##   ..@ skeleton  : language (new("derivedDefaultMethod", .Data = function (variance.model = list(model = "sGARCH",      garchOrder = c(1, 1),| __truncated__ ...
}

The Garch order for the variance model is provided using \code{arch_order} and \code{garch_order} parameters..
The ARMA order for the mean model is provided using \code{ar_order} and \code{ma_order} parameters.
Other options and arguments can be set using \code{set_engine()}.

#' Parameter Notes:
\itemize{
\item \code{xreg} - This engine supports xregs for both the variance model and the mean model. You can do this in two ways,
either enter the matrices through set_engine parameters or as a formula in fit (note that the latter option is more limited,
since you will not be able to pass two different xregs, one for each model). For simpler cases this is a compact option.
\item \verb{order parameters} - The parameters of rugarch::ugarchspec are lists containing several elements,
some of them the commands that are the main arguments of the function. If you want to modify the parameter
that encompasses such a list, you must know that the parameter passed in the function parameter will always prevail.
(See Examples).
}
}

\section{Fit Details}{


\strong{Date and Date-Time Variable}

It's a requirement to have a date or date-time variable as a predictor.
The \code{fit()} interface accepts date and date-time features and handles them internally.
\itemize{
\item \code{fit(y ~ date)}
}

\strong{Univariate (No xregs, Exogenous Regressors):}

For univariate analysis, you must include a date or date-time feature. Simply use:
\itemize{
\item Formula Interface: \code{fit(y ~ date)} will ignore xreg's.
}

\strong{Multivariate (xregs, Exogenous Regressors)}

The \code{xreg} parameter is populated using the \code{fit()} function:
\itemize{
\item Only \code{factor}, \verb{ordered factor}, and \code{numeric} data will be used as xregs.
\item Date and Date-time variables are not used as xregs
\item \code{character} data should be converted to factor.
}

\emph{Xreg Example:} Suppose you have 3 features:
\enumerate{
\item \code{y} (target)
\item \code{date} (time stamp),
\item \code{month.lbl} (labeled month as a ordered factor).
}

The \code{month.lbl} is an exogenous regressor that can be passed to the \code{garch_reg()} using
\code{fit()}:
\itemize{
\item \code{fit(y ~ date + month.lbl)} will pass \code{month.lbl} on as an exogenous regressor.
}

Note that date or date-time class values are excluded from \code{xreg}.
}

\examples{
\donttest{
library(tidymodels)
library(garchmodels)
library(modeltime)
library(tidyverse)
library(timetk)
library(lubridate)

rIBM_extended <- rIBM \%>\%
    future_frame(.length_out = 24, .bind_data = TRUE) 

rIBM_train  <- rIBM_extended \%>\% drop_na()
rIBM_future <- rIBM_extended \%>\% filter(is.na(daily_returns))

model_garch_fit <-garchmodels::garch_reg(mode = "regression",
                                          arch_order = 1,
                                          garch_order = 1) \%>\%
    set_engine("rugarch") \%>\%
    fit(daily_returns ~ date, data = rIBM_train)

predict(model_garch_fit, rIBM_future)

model_garch_fit <-garchmodels::garch_reg(mode = "regression",
                                        arch_order = 2,
                                        garch_order = 2) \%>\%
    set_engine("rugarch", variance.model = list(model='gjrGARCH', 
                                                garchOrder=c(1,1)),
               mean.model     = list(armaOrder=c(0,0))) \%>\%
    fit(daily_returns ~ date, data = rIBM_train)

predict(model_garch_fit, rIBM_future)
} 
}
\seealso{
\code{\link[=fit.model_spec]{fit.model_spec()}}, \code{\link[=set_engine]{set_engine()}}
}
