// Generated by rstantools.  Do not edit by hand.

/*
    breathteststan is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    breathteststan is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with breathteststan.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_powexp_gastro_1b_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_powexp_gastro_1b");
    reader.add_event(50, 48, "end", "model_powexp_gastro_1b");
    return reader;
}
#include <stan_meta_header.hpp>
class model_powexp_gastro_1b
  : public stan::model::model_base_crtp<model_powexp_gastro_1b> {
private:
        double prior_v0;
        int n;
        int n_record;
        std::vector<int> record;
        vector_d minute;
        vector_d volume;
public:
    model_powexp_gastro_1b(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_powexp_gastro_1b(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_powexp_gastro_1b_namespace::model_powexp_gastro_1b";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 7;
            context__.validate_dims("data initialization", "prior_v0", "double", context__.to_vec());
            prior_v0 = double(0);
            vals_r__ = context__.vals_r("prior_v0");
            pos__ = 0;
            prior_v0 = vals_r__[pos__++];
            current_statement_begin__ = 8;
            context__.validate_dims("data initialization", "n", "int", context__.to_vec());
            n = int(0);
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            n = vals_i__[pos__++];
            check_greater_or_equal(function__, "n", n, 0);
            current_statement_begin__ = 9;
            context__.validate_dims("data initialization", "n_record", "int", context__.to_vec());
            n_record = int(0);
            vals_i__ = context__.vals_i("n_record");
            pos__ = 0;
            n_record = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_record", n_record, 0);
            current_statement_begin__ = 10;
            validate_non_negative_index("record", "n", n);
            context__.validate_dims("data initialization", "record", "int", context__.to_vec(n));
            record = std::vector<int>(n, int(0));
            vals_i__ = context__.vals_i("record");
            pos__ = 0;
            size_t record_k_0_max__ = n;
            for (size_t k_0__ = 0; k_0__ < record_k_0_max__; ++k_0__) {
                record[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 11;
            validate_non_negative_index("minute", "n", n);
            context__.validate_dims("data initialization", "minute", "vector_d", context__.to_vec(n));
            minute = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("minute");
            pos__ = 0;
            size_t minute_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < minute_j_1_max__; ++j_1__) {
                minute(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 12;
            validate_non_negative_index("volume", "n", n);
            context__.validate_dims("data initialization", "volume", "vector_d", context__.to_vec(n));
            volume = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("volume");
            pos__ = 0;
            size_t volume_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < volume_j_1_max__; ++j_1__) {
                volume(j_1__) = vals_r__[pos__++];
            }
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 16;
            validate_non_negative_index("v0", "n_record", n_record);
            num_params_r__ += n_record;
            current_statement_begin__ = 17;
            validate_non_negative_index("beta", "n_record", n_record);
            num_params_r__ += n_record;
            current_statement_begin__ = 18;
            validate_non_negative_index("tempt", "n_record", n_record);
            num_params_r__ += n_record;
            current_statement_begin__ = 19;
            num_params_r__ += 1;
            current_statement_begin__ = 20;
            num_params_r__ += 1;
            current_statement_begin__ = 21;
            num_params_r__ += 1;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_powexp_gastro_1b() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 16;
        if (!(context__.contains_r("v0")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable v0 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("v0");
        pos__ = 0U;
        validate_non_negative_index("v0", "n_record", n_record);
        context__.validate_dims("parameter initialization", "v0", "vector_d", context__.to_vec(n_record));
        Eigen::Matrix<double, Eigen::Dynamic, 1> v0(n_record);
        size_t v0_j_1_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < v0_j_1_max__; ++j_1__) {
            v0(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, v0);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable v0: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 17;
        if (!(context__.contains_r("beta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        validate_non_negative_index("beta", "n_record", n_record);
        context__.validate_dims("parameter initialization", "beta", "vector_d", context__.to_vec(n_record));
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta(n_record);
        size_t beta_j_1_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            beta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, beta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 18;
        if (!(context__.contains_r("tempt")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable tempt missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("tempt");
        pos__ = 0U;
        validate_non_negative_index("tempt", "n_record", n_record);
        context__.validate_dims("parameter initialization", "tempt", "vector_d", context__.to_vec(n_record));
        Eigen::Matrix<double, Eigen::Dynamic, 1> tempt(n_record);
        size_t tempt_j_1_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < tempt_j_1_max__; ++j_1__) {
            tempt(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, tempt);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable tempt: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 19;
        if (!(context__.contains_r("sigma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "sigma", "double", context__.to_vec());
        double sigma(0);
        sigma = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, sigma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 20;
        if (!(context__.contains_r("mu_beta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable mu_beta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("mu_beta");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "mu_beta", "double", context__.to_vec());
        double mu_beta(0);
        mu_beta = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, mu_beta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable mu_beta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 21;
        if (!(context__.contains_r("sigma_beta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma_beta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma_beta");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "sigma_beta", "double", context__.to_vec());
        double sigma_beta(0);
        sigma_beta = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, sigma_beta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma_beta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 16;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> v0;
            (void) v0;  // dummy to suppress unused var warning
            if (jacobian__)
                v0 = in__.vector_lb_constrain(0, n_record, lp__);
            else
                v0 = in__.vector_lb_constrain(0, n_record);
            current_statement_begin__ = 17;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta;
            (void) beta;  // dummy to suppress unused var warning
            if (jacobian__)
                beta = in__.vector_lb_constrain(0, n_record, lp__);
            else
                beta = in__.vector_lb_constrain(0, n_record);
            current_statement_begin__ = 18;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tempt;
            (void) tempt;  // dummy to suppress unused var warning
            if (jacobian__)
                tempt = in__.vector_lb_constrain(0, n_record, lp__);
            else
                tempt = in__.vector_lb_constrain(0, n_record);
            current_statement_begin__ = 19;
            local_scalar_t__ sigma;
            (void) sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma = in__.scalar_lb_constrain(0, lp__);
            else
                sigma = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 20;
            local_scalar_t__ mu_beta;
            (void) mu_beta;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_beta = in__.scalar_lb_constrain(0, lp__);
            else
                mu_beta = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 21;
            local_scalar_t__ sigma_beta;
            (void) sigma_beta;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_beta = in__.scalar_lb_constrain(0, lp__);
            else
                sigma_beta = in__.scalar_lb_constrain(0);
            // model body
            {
            current_statement_begin__ = 26;
            int reci(0);
            (void) reci;  // dummy to suppress unused var warning
            stan::math::fill(reci, std::numeric_limits<int>::min());
            current_statement_begin__ = 27;
            local_scalar_t__ v0r(DUMMY_VAR__);
            (void) v0r;  // dummy to suppress unused var warning
            stan::math::initialize(v0r, DUMMY_VAR__);
            stan::math::fill(v0r, DUMMY_VAR__);
            current_statement_begin__ = 28;
            local_scalar_t__ betar(DUMMY_VAR__);
            (void) betar;  // dummy to suppress unused var warning
            stan::math::initialize(betar, DUMMY_VAR__);
            stan::math::fill(betar, DUMMY_VAR__);
            current_statement_begin__ = 29;
            local_scalar_t__ temptr(DUMMY_VAR__);
            (void) temptr;  // dummy to suppress unused var warning
            stan::math::initialize(temptr, DUMMY_VAR__);
            stan::math::fill(temptr, DUMMY_VAR__);
            current_statement_begin__ = 30;
            validate_non_negative_index("vol", "n", n);
            std::vector<local_scalar_t__  > vol(n, local_scalar_t__(DUMMY_VAR__));
            stan::math::initialize(vol, DUMMY_VAR__);
            stan::math::fill(vol, DUMMY_VAR__);
            current_statement_begin__ = 31;
            lp_accum__.add(normal_log<propto__>(mu_beta, 1.5, 0.5));
            current_statement_begin__ = 32;
            lp_accum__.add(normal_log<propto__>(sigma_beta, 1, 0.5));
            current_statement_begin__ = 34;
            lp_accum__.add(normal_log<propto__>(v0, prior_v0, 100));
            current_statement_begin__ = 35;
            lp_accum__.add(lognormal_log<propto__>(beta, mu_beta, sigma_beta));
            current_statement_begin__ = 36;
            lp_accum__.add(normal_log<propto__>(tempt, 60, 20));
            current_statement_begin__ = 37;
            lp_accum__.add(gamma_log<propto__>(sigma, 20, 0.5));
            current_statement_begin__ = 39;
            for (int i = 1; i <= n; ++i) {
                current_statement_begin__ = 40;
                stan::math::assign(reci, get_base1(record, i, "record", 1));
                current_statement_begin__ = 41;
                stan::math::assign(v0r, get_base1(v0, reci, "v0", 1));
                current_statement_begin__ = 42;
                stan::math::assign(betar, get_base1(beta, reci, "beta", 1));
                current_statement_begin__ = 43;
                stan::math::assign(temptr, get_base1(tempt, reci, "tempt", 1));
                current_statement_begin__ = 44;
                stan::model::assign(vol, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (v0r * stan::math::exp(-(pow((get_base1(minute, i, "minute", 1) / temptr), betar)))), 
                            "assigning variable vol");
            }
            current_statement_begin__ = 46;
            lp_accum__.add(normal_log<propto__>(volume, vol, sigma));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("v0");
        names__.push_back("beta");
        names__.push_back("tempt");
        names__.push_back("sigma");
        names__.push_back("mu_beta");
        names__.push_back("sigma_beta");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_powexp_gastro_1b_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> v0 = in__.vector_lb_constrain(0, n_record);
        size_t v0_j_1_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < v0_j_1_max__; ++j_1__) {
            vars__.push_back(v0(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta = in__.vector_lb_constrain(0, n_record);
        size_t beta_j_1_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            vars__.push_back(beta(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> tempt = in__.vector_lb_constrain(0, n_record);
        size_t tempt_j_1_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < tempt_j_1_max__; ++j_1__) {
            vars__.push_back(tempt(j_1__));
        }
        double sigma = in__.scalar_lb_constrain(0);
        vars__.push_back(sigma);
        double mu_beta = in__.scalar_lb_constrain(0);
        vars__.push_back(mu_beta);
        double sigma_beta = in__.scalar_lb_constrain(0);
        vars__.push_back(sigma_beta);
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            if (!include_gqs__ && !include_tparams__) return;
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_powexp_gastro_1b";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t v0_j_1_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < v0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_j_1_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t tempt_j_1_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < tempt_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tempt" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_beta";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t v0_j_1_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < v0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_j_1_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t tempt_j_1_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < tempt_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tempt" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_beta";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
    }
}; // model
}  // namespace
typedef model_powexp_gastro_1b_namespace::model_powexp_gastro_1b stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
