% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f1st.R
\name{f1st}
\alias{f1st}
\title{Stepwise selection of covariates}
\usage{
f1st(y,x,p0=0.01,nu=1,km=0,mx=21,kx=0,sub=F,inr=T,xinr=F)
}
\arguments{
\item{y}{Dependent variable}

\item{x}{Covariates}

\item{p0}{The P-value cut-off}

\item{nu}{The order statistic of Gaussian covariates used for comparison}

\item{km}{The maximum number of included covariates}

\item{mx}{The maximum number covariates for an all subset search}

\item{kx}{The excluded covariates}

\item{sub}{Logical if TRUE best subset selected.to include intercept}

\item{inr}{Logical if TRUE include intercept if not present}

\item{xinr}{Logical if TRUE intercept already present}
}
\value{
pv The in order selected covariates, the regression coefficients, the P-values, the standard P-values.

res The residuals

stpv The in order stepwise P-values, sum of squared residuals and the percentage sum of squared residuals explained
}
\description{
Stepwise selection of covariates
}
\examples{
data(boston)
bostint<-fgeninter(boston[,1:13],2)[[1]]
a<-f1st(boston[,14],bostint,km=10,sub=TRUE)
}
