% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_gbfs.R
\name{get_which_gbfs_feeds}
\alias{get_which_gbfs_feeds}
\title{Get dataframe of bikeshare feeds released by a city}
\source{
North American Bikeshare Association, General Bikeshare Feed 
Specification \url{https://github.com/NABSA/gbfs/blob/master/gbfs.md}
}
\usage{
get_which_gbfs_feeds(city)
}
\arguments{
\item{city}{A character string that can be matched to a city or a url to 
an active gbfs .json feed. See [get_gbfs_cities()] for a 
current list of available cities.}
}
\value{
A \code{data.frame} containing the feeds supplied by
a city. . The `feed` column supplies the name of the relevant .json feeds, 
while the entries in the `URL` column supply the feeds themselves.
}
\description{
Of the different types of feeds supplied by the gbfs,
some are required, some are conditionally required, and some are
optional. This function grabs a list of each of the feeds supplied
by a given city, as well as the URLs to access them.
}
\examples{
# grab all of the feeds released by memphis
\donttest{get_which_gbfs_feeds(city = "memphis")}

}
