% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{import_blockdesigns}
\alias{import_blockdesigns}
\title{Import blockdesigns}
\usage{
import_blockdesigns(files, block_names = NULL, sep = NULL, ...)
}
\arguments{
\item{files}{Vector of filenames (as strings), each of which is a 
block-shaped designs file. Inputs can be .csv, .xls, or .xlsx}

\item{block_names}{Vector of names for design elements. These will be the
resulting column names in the output data frame. Should be 
in the same order as \code{files} and/or same order
as corresponding \code{files} themselves. If \code{NULL},
file names will be used as column names.}

\item{sep}{If block design files are already pasted,
sep specifies the string separating design elements

If NULL, \code{import_blockdesigns} will assume no elements
are already pasted together and attempt to find a character
not used in the imported files to paste and later separate
design elements.}

\item{...}{Other arguments to pass to \code{read_blocks}, 
\code{paste_blocks}, \code{trans_block_to_wide},
\code{trans_wide_to_tidy}, or \code{separate_tidy}.

See Details for more information}
}
\value{
A tidy-shaped \code{data.frame} containing the design information
        from \code{files}
}
\description{
Function to import block-shaped designs from files and return tidy designs.
This function acts as a wrapper to call \code{read_blocks}, 
\code{paste_blocks}, \code{trans_block_to_wide}, \code{trans_wide_to_tidy}, 
and \code{separate_tidys} in one go
}
\details{
Common arguments that you may want to provide include:

             \code{startrow}, \code{endrow}, \code{startcol}, \code{endcol}, 
             \code{sheet} - specifying the location of design information 
             inside \code{files} to \code{read_blocks}
             
             \code{wellnames_sep} - specifying what character (or "" for none)
             should be used when pasting together the rownames and
             column names. Note that this should be chosen to match
             the wellnames in your measures.
             
             Note that \code{import_blockdesigns} cannot currently handle
             metadata specified via the \code{metadata} argument of
             \code{read_blocks}
}
