% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gRasterize.R
\name{gRasterize}
\alias{gRasterize}
\title{Fast rasterize for Spatial objects}
\usage{
gRasterize(SPDF, r, field, filename = "")
}
\arguments{
\item{SPDF}{A \code{Spatial*} object to be rasterized.}

\item{r}{A \code{Raster*} object to be used as the rasterization
template.}

\item{field}{Character. The name of the numeric column in
\code{data.frame()} that will be written to the output Raster*
object.}

\item{filename}{Character. Output filename (optional). If none is
supplied, the resulting raster will be stored \code{inMemory}
(unless it is too large, as determined by a call to
\code{canProcessInMemory(y, 3)}}
}
\value{
A \code{RasterLayer} object containing a rasterized
    version of \code{SPDF}.
}
\description{
Rasterize \code{Spatial*} objects using gdal_rasterize.
}
\details{
For a 1000-by-1000 raster, \code{gRasterize} is more than 6 times
faster than \code{raster::rasterize}. For a 2000-by-2000 raster,
it is almost 12 times faster (6 seconds vs. 70 seconds on my
Windows laptop).

I've modeled \code{gRasterize} arguments and behavior on that of
\code{\link[raster]{rasterize}}. Like\code{rasterize},it takes a
\code{filename=} argument which defaults to \code{""} in which
case (unless it's determined internally that
\code{!canProcessInMemory(rstr, 3)}) the returned raster is
\code{'inMemory'}. Otherwise, if the raster is too large or if a
filename is supplied, it's returned \code{fromDisk}.

Internally, \code{\link{gdal_rasterize}} by default writes to a
file, and only optionally returns an R \code{Raster} object (when
its \code{output_Raster = TRUE}); to get the raster
\code{'inMemory'}, I use \code{\link[raster]{readAll}} (after a
check that it's really OK, memory-wise to do so).
}
\examples{
\donttest{
SPDF <- shapefile(system.file("external/lux.shp", package="raster"))
## rr <- raster(extent(SPDF), ncol=100, nrow=100, crs=proj4string(SPDF))
llratio <- 1/cos(pi*mean(coordinates(SPDF)[,2])/180)
rr <- raster(extent(SPDF),
             resolution=c(llratio*0.01, 0.01),
             crs=proj4string(SPDF))

## An example using an integer-valued field
rInt <- gRasterize(SPDF, rr, field = "ID_2")
plot(rInt, col = RColorBrewer::brewer.pal(name = "Paired", 12))
plot(SPDF, lwd = 3, border = "grey30", add = TRUE)

## An example using a character-valued field
rFac <- gRasterize(SPDF, rr, field = "NAME_2")
rasterVis::levelplot(rFac)
}
}
\author{
Joshua O'Brien
}
