% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cube.R
\name{raster_cube}
\alias{raster_cube}
\title{Create a data cube from an image collection}
\usage{
raster_cube(image_collection, view, chunking = c(16, 256, 256))
}
\arguments{
\item{image_collection}{Source image collection as from \code{image_collection} or \code{create_image_collection}}

\item{view}{A data cube view defining the shape (spatiotemporal extent, resolution, and spatial reference), if missing, a default overview is used}

\item{chunking}{Vector of length 3 defining the size of data cube chunks in the order time, y, x.}
}
\value{
A proxy data cube object
}
\description{
Create a proxy data cube, which loads data from a given image collection according to a data cube view
}
\details{
The following steps will be performed when the data cube is requested to read data of a chunk:

 1. Filter images from the input collection that intersect with the spatiotemporal extent of the chunk
 2. For all resulting images, apply gdalwarp to reproject / warp the image to the target SRS and size to a GDAL MEM dataset
 3. Read the resulting data to the chunk buffer and if pixels already contain non NAN values, apply an aggregation method (as defined in the view)
}
\note{
This function returns a proxy object, i.e., it will not start any computations besides deriving the shape of the result.
}
\examples{
# create image collection from example Landsat data only 
# if not already done in other examples
if (!file.exists(file.path(tempdir(), "L8.db"))) {
  L8_files <- list.files(system.file("L8NY18", package = "gdalcubes"),
                         ".TIF", recursive = TRUE, full.names = TRUE)
  create_image_collection(L8_files, "L8_L1TP", file.path(tempdir(), "L8.db")) 
}

L8.col = image_collection(file.path(tempdir(), "L8.db"))
v = cube_view(extent=list(left=388941.2, right=766552.4, 
              bottom=4345299, top=4744931, t0="2018-01", t1="2018-12"),
              srs="EPSG:32618", nx = 497, ny=526, dt="P1M")
raster_cube(L8.col, v)
 
}
