% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reference_funcs.R
\name{gdl_regions}
\alias{gdl_regions}
\title{Get region list}
\usage{
gdl_regions(session, country)
}
\arguments{
\item{session}{A valid GDL session object to interface with.}

\item{country}{An ISO3 country code.}
}
\value{
A data frame containing a list of regions for the country.
}
\description{
Returns a list of regions available for a particular country.
}
\examples{
\dontrun{
# Create a session using your API token (provided by environment here)
session <- gdl_session(Sys.getenv('GDL_API_TOKEN'))
# Request list of regions for India
regions <- gdl_regions(session, 'IND')
head(regions, n=10)
}
}
