% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_helper.R
\name{inverse_distance_weight}
\alias{inverse_distance_weight}
\title{calculate inverse distance weight}
\usage{
inverse_distance_weight(locx, locy, power = 1, is_arc = FALSE)
}
\arguments{
\item{locx}{The x axis location.}

\item{locy}{The y axis location.}

\item{power}{(optional) Default is 1. Set to 2 for gravity weights.}

\item{is_arc}{(optional) \code{FALSE} (default) or \code{TRUE}, whether to compute arc distance.}
}
\value{
A inverse distance weight matrices with class of \code{matrix}.
}
\description{
Function for calculate inverse distance weight.
}
\details{
The inverse distance weight formula is
\eqn{w_{ij} = 1 / d_{ij}^\alpha}
}
\examples{
x = 1:10
y = 1:10
inverse_distance_weight(x,y)
inverse_distance_weight(x,y,is_arc = TRUE)

}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
