% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rid.R
\name{rid}
\alias{rid}
\title{robust interaction detector(RID) model}
\usage{
rid(formula, data, discvar = NULL, discnum = 10, minsize = 1, cores = 1)
}
\arguments{
\item{formula}{A formula of RID model.}

\item{data}{A \code{data.frame}, \code{tibble} or \code{sf} object of observation data.}

\item{discvar}{Name of continuous variable columns that need to be discretized. Noted that
when \code{formula} has \code{discvar}, \code{data} must have these columns. By default, all independent
variables are used as \code{discvar}.}

\item{discnum}{A numeric vector for the number of discretized classes of columns that need
to be discretized. Default all \code{discvar} use \code{10}.}

\item{minsize}{(optional) The min size of each discretization group. Default all use \code{1}.}

\item{cores}{(optional) Positive integer (default is 1). When cores are greater than 1, use
multi-core parallel computing.}
}
\value{
A list.
\describe{
\item{\code{interaction}}{the result of RID model}
}
}
\description{
Function for robust interaction detector(RID) model.
}
\note{
Please set up python dependence and configure \code{GDVERSE_PYTHON} environment variable if you want to run \code{rid()}.
See \code{vignette('rgdrid',package = 'gdverse')} for more details.
}
\examples{
\dontrun{
## The following code needs to configure the Python environment to run:
data('sim')
g = rid(y ~ .,
        data = dplyr::select(sim,-dplyr::any_of(c('lo','la'))),
        discnum = 4, cores = 6)
g
}
}
\references{
Zhang, Z., Song, Y., Karunaratne, L., & Wu, P. (2024). Robust interaction detector:
A case of road life expectancy analysis. Spatial Statistics, 59(100814), 100814.
https://doi.org/10.1016/j.spasta.2024.100814
}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
