% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_summary}
\alias{plot_summary}
\title{plot simulation default summary object}
\usage{
plot_summary(output, summary_title = NULL, summary_legend = NULL)
}
\arguments{
\item{output}{tsgen3sis output object resulting from a gen3sis simulation}

\item{summary_title}{summary plot title as character. If NULL, title computed from input name.}

\item{summary_legend}{either a staring with _\_n for new lines or NULL. If NULL, provides default summary and simulation information.}
}
\description{
plot simulation default summary object
}
\examples{
# load existing summary example
datapath <- system.file(file.path("extdata", "WorldCenter"), package = "gen3sis")
output <- readRDS(file.path(datapath, "output/config_worldcenter/sgen3sis.rds"))
# plot output summary
plot_summary(output)

\donttest{
## run simulation and plot summary
# get path or correct input objects
datapath <- system.file(file.path("extdata", "CaseStudy1"), package="gen3sis")
# run simulation and store summary object to output
output <- run_simulation(config = file.path(datapath,"config/config_fast.R"), 
                      landscape = file.path(datapath,"landscape"),
                      output_directory = tempdir())
# plot output summary
plot_summary(output)
}
}
\seealso{
\code{\link{run_simulation}}
}
