% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config_handling.R
\name{verify_config}
\alias{verify_config}
\title{Verifies if all required config fields are provided}
\usage{
verify_config(config)
}
\arguments{
\item{config}{a config object}
}
\value{
Returns TRUE for a valid config, FALSE otherwise, in which case a list of
missing parameters will be printed out as well
}
\description{
Verifies if all required config fields are provided
}
\examples{
# get path to input config
datapath <- system.file(file.path("extdata", "WorldCenter"), package="gen3sis")
path_config <- file.path(datapath, "config/config_worldcenter.R")
# create config object
config_object <- create_input_config(path_config)
# check class
class(config_object)
# verify config
verify_config(config_object) # TRUE! this is a valid config

# break config_object, change name random_seed to r4nd0m_s33d
names(config_object$gen3sis$general)[1] <- "r4nd0m_s33d"
verify_config(config_object) # FALSE! this is an invalid config
}
\seealso{
\code{\link{create_input_config}}    \code{\link{write_config_skeleton}}
}
