% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/findGivenNames.R
\name{findGivenNames}
\alias{findGivenNames}
\title{Getting gender prediction data for a given text vector.}
\usage{
findGivenNames(x, apikey = NULL, queryLength = 10, progress = TRUE,
  ssl.verifypeer = TRUE)
}
\arguments{
\item{x}{A text vector.}

\item{apikey}{A character string with the API key obtained via https://store.genderize.io. A default is NULL, which uses the free API plan.}

\item{queryLength}{How much terms can be check in a one single query}

\item{progress}{If TRUE (default) progress bar is displayed in the console}

\item{ssl.verifypeer}{Checks the SSL Cerftificate. Default is TRUE.}
}
\value{
A data table with names gener probabilities and counts for terms in given text vector.
}
\description{
\code{findGivenNames} extract from text unique terms and gets the gender predicion for all these terms.
}
\examples{
\dontrun{

grid = (expand.grid(a=letters,b=letters))
findGivenNames(paste0(grid$a,grid$b))

}
}

