% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectionResult.R
\name{selectionResult}
\alias{selectionResult}
\title{selectionResult class}
\description{
A result of applying SLOPE to matrix of SNPs obtained by
clumping produced. Result of function \code{\link{select_snps}}
}
\details{
Always a named list of eighteen elements
\enumerate{
\item \code{X} numeric matrix, consists of one snp representative for each clump
selected by SLOPE
\item \code{effects} numeric vector, coefficients in linear model build on
snps selected by SLOPE
\item \code{R2} numeric, value of R-squared in linear model build on
snps selected by SLOPE
\item \code{selectedSNPs} which columns in matrix \code{X_all}
are related to snps selected by SLOPE
\item \code{y} selectedClumps list of numeric vectors, which columns in SNP matrix
\code{X_all} are related to clump members selected by SLOPE
\item \code{lambda} numeric vector, lambda values used by SLOPE procedure
\item \code{y} numeric vector, phenotype
\item \code{clumpRepresentatives} numeric vector, which columns in SNP matrix \code{X_all}
are related to clumps representatives
\item \code{clumps} list of numeric vectors, which columns in SNP matrix
\code{X_all} are related to clump members
\item \code{X_info} data.frame, mapping information about SNPs from .map file.
Copied from the result of clumping procedure
\item \code{X_clumps} numeric matrix, consists of one snp representative for each clump
\item \code{X_all} numeric matrix, all the snps that passed screening procedure
\item \code{selectedSnpsNumbers} numeric vector, which rows of \code{X_info}
data.frame are related to snps that were selected by SLOPE
\item \code{clumpingRepresentativesNumbers} numeric vector, which rows of \code{X_info}
data.frame are related to snps that are clump represenatives
\item \code{screenedSNPsNumbers} numeric vector, which rows of \code{X_info}
data.frame are related to snps that passed screening
\item \code{numberOfSnps} numeric, total number of SNPs before screening procedure
\item \code{pValMax} numeric, p-value used in screening procedure
\item \code{fdr} numeric, false discovery rate used by \code{\link{SLOPE}}
}
}
\seealso{
\code{\link{screeningResult}} \code{\link{clumpingResult}}
\code{\link{select_snps}} \code{\link[SLOPE]{SLOPE}}
}

