% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGSEA.R
\name{plotGSEA}
\alias{plotGSEA}
\title{GSEA plot}
\usage{
plotGSEA(
  gsea_list,
  plot_type = c("volcano", "classic", "fgsea"),
  show_pathway = 3,
  show_genes = NULL,
  colors = NULL,
  ...
)
}
\arguments{
\item{gsea_list}{GSEA result from `genGSEA` function}

\item{plot_type}{GSEA plot type, one of 'volcano', 'classic' or 'fgsea'.}

\item{show_pathway}{Which pathways included, user could specify number (default is 3) or
character name.}

\item{show_genes}{Character to specify gene names included in plot when `plot_type` is "pathway".}

\item{colors}{Character to specify colors when `plot_type` is "pathway".}

\item{...}{other arguments transfer to `plot_theme` function}
}
\value{
A ggplot object
}
\description{
GSEA plot
}
\examples{
\dontrun{
library(ggplot2)
# get GSEA result
data(geneList, package = "genekitr")
gse <- genGSEA(genelist = geneList, org = "human",
               category = "H",use_symbol = TRUE, pvalueCutoff = 1)
# volcano plot
plotGSEA(gse, plot_type = c('volcano'), show_pathway = 3)

# classic pathway plot
plotGSEA(gse, plot_type = c('classic'), show_pathway = 1:2)

# fgsea for multiple pathway
plotGSEA(gse, plot_type = c('fgsea'), show_pathway = 10)

}

}
