% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expoSheet.R
\name{expoSheet}
\alias{expoSheet}
\title{Export list of data sets into different 'Excel' sheets}
\usage{
expoSheet(
  data_list,
  data_name,
  filename = NULL,
  dir = tempdir(),
  overwrite = TRUE
)
}
\arguments{
\item{data_list}{List of datasets.}

\item{data_name}{Character of data names.}

\item{filename}{A character string naming an xlsx file.}

\item{dir}{A character string naming output directory.}

\item{overwrite}{If TRUE, overwrite any existing file.}
}
\value{
An Excel file.
}
\description{
Export list of data sets into different 'Excel' sheets
}
\examples{
library(openxlsx)
expoSheet(
  data_list = list(mtcars, ToothGrowth),
  data_name = c("mtcars", "tooth"),
  filename = "test.xlsx", dir = tempfile()
)
}
