% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naTriplet.R
\name{naTriplet}
\alias{naTriplet}
\title{Function to do matdched deletion of missing rows from x, y and control variable(s).}
\usage{
naTriplet(x, y, ctrl)
}
\arguments{
\item{x}{Vector of x data}

\item{y}{Vector of y data}

\item{ctrl}{{Data matrix on the control variable(s) kept beyond causal path issues}}
}
\value{
\item{newx}{A new vector x after removing triplet-wise missing data} 
\item{newy}{A new vector y after removing triplet-wise missing data} 
\item{newctrl}{A new vector ctrl after removing triplet-wise missing data}
}
\description{
The aim in three-way deletions is to retain only the largest 
number of available data triplets with all non-missing data.
}
\examples{

\dontrun{
x=sample(1:10);y=sample(1:10);x[2]=NA; y[3]=NA
w=sample(2:11)
naTriplet(x,y,w)}

}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
\seealso{
See \code{\link{napair}}.
}

