% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_portfo2.R
\name{comp_portfo2}
\alias{comp_portfo2}
\title{Compares two vectors (portfolios) using stochastic dominance of orders 1 to 4.}
\usage{
comp_portfo2(xa, xb)
}
\arguments{
\item{xa}{{Data on returns for portfolio A in the form of a T by 1 vector}}

\item{xb}{{Data on returns for portfolio B in the form of a T by 1 vector}}
}
\value{
Returns four numbers which are averages of four sophisticated measures of stochastic
dominance measurements called SD1 to SD4.
}
\description{
Given two vectors of portfolio returns this function calls the internal function wtdpapb
to report the simple means of four sophisticated measures of stochastic dominance.
}
\note{
It is possible to modify this function to report the median or standard
deviation or any other descriptive statistic by changing the line in the
code '\code{oumean = apply(outb, 2, mean)}' toward the end of this function.
A trimmed mean may be of interest when outliers are suspected.

require(np)

Make sure that functions wtdpapb, bigfp, stochdom2 are in the memory.
and options(np.messages=FALSE)
}
\examples{

set.seed(30)
xa=sample(20:30)#generally lower returns
xb=sample(32:40)# higher returns in xb
gp = comp_portfo2(xa, xb)#all Av(sdi) positive means xb dominates
##positive SD1 to SD4 means xb dominates xa as it should

}
\references{
Vinod, H. D.", "Hands-On Intermediate Econometrics 
Using R"  (2008) World Scientific Publishers: Hackensack, NJ. (Chapter 4)
\url{http://www.worldscibooks.com/economics/6895.html}
}
\seealso{
\code{\link{stochdom2}}
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
\keyword{SD1}
\keyword{SD2}
\keyword{SD3}
\keyword{SD4}
\keyword{bigfp}
\keyword{dominance}
\keyword{stochastic}
\keyword{wtdpapb}
