% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parcorBMany.R
\name{parcorBMany}
\alias{parcorBMany}
\title{Block version reports many generalized partial correlation coefficients 
allowing control variables.}
\usage{
parcorBMany(mtx, ctrl = 0, dig = 4, idep = 1, blksiz = 10, verbo = FALSE)
}
\arguments{
\item{mtx}{{Input data matrix with at least 3 columns.}}

\item{ctrl}{{Input vector or matrix of data for control variable(s), 
default is ctrl=0 when control variables are absent}}

\item{dig}{The number of digits for reporting (=4, default)}

\item{idep}{The column number of the dependent variable (=1, default)}

\item{blksiz}{{block size, default=10, if chosen blksiz >n, where n=rows in matrix
then blksiz=n. That is, no blocking is done}}

\item{verbo}{Make this TRUE for detailed printing of computational steps}
}
\value{
A five column `out' matrix containing partials. The first column
  has the name of the \code{idep} variable. The
   second column has the name of the j variable, while the third column 
   has partial correlation coefficients  r*(i,j | k).The last column
   reports the absolute difference between two partial correlations.
}
\description{
This function calls a block version \code{parcorBijk} of the function which
uses original data to compute
generalized partial correlations between \eqn{X_{idep}} and \eqn{X_j}
where j can be any one of the remaining
variables in the input matrix \code{mtx}. Partial correlations remove the effect of
variables \eqn{X_k} other than \eqn{X_i} and \eqn{X_j}. Calculation further 
allows for the presence of control variable(s) (if any) to remain always outside
the input matrix and whose effect is also removed in computing partial correlations.
}
\note{
This function reports all partial
 correlation coefficients, while avoiding ridge type adjustment.
}
\examples{
set.seed(234)
z=runif(10,2,11)# z is independently created
x=sample(1:10)+z/10  #x is partly indep and partly affected by z
y=1+2*x+3*z+rnorm(10)# y depends on x and z not vice versa
mtx=cbind(x,y,z)
parcorBMany(mtx, blksiz=10)
 
   
\dontrun{
set.seed(34);x=matrix(sample(1:600)[1:99],ncol=3)
colnames(x)=c('V1', 'v2', 'V3')
parcorBMany(x, idep=1)
}

}
\references{
Vinod, H. D. 'Generalized Correlations and Instantaneous
 Causality for Data Pairs Benchmark,' (March 8, 2015)
 \url{https://www.ssrn.com/abstract=2574891}

Vinod, H. D. (2021) 'Generalized, Partial and Canonical Correlation
Coefficients' Computational Economics, 59(1), 1--28.

Vinod, H. D. 'Matrix Algebra Topics in Statistics and Economics
 Using R', Chapter 4 in Handbook of Statistics: Computational Statistics
 with R, Vol.32, co-editors: M. B. Rao and C.R. Rao. New York:
 North Holland, Elsevier Science Publishers, 2014, pp. 143-176.
}
\seealso{
See Also \code{\link{parcor_ijk}}, \code{\link{parcorMany}}.
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY.
}
\concept{partial correlations}
