% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parcor_linear.R
\name{parcor_linear}
\alias{parcor_linear}
\title{Partial correlation coefficient between Xi and Xj after removing the linear
effect of all others.}
\usage{
parcor_linear(x, i, j)
}
\arguments{
\item{x}{{Input a p by p matrix R of symmetric correlation coefficients.}}

\item{i}{{A column number identifying the first variable.}}

\item{j}{{A column number identifying the second variable.}}
}
\value{
\item{ouij}{Partial correlation Xi with Xj after removing all other X's}
\item{ouji}{Partial correlation Xj with Xi after removing all other X's}
\item{myk}{A list of column numbers whose effect has been removed}
}
\description{
This function uses a symmetric correlation matrix R as input to compute
usual partial correlations between \eqn{X_i} and \eqn{X_j}
where j can be any one of the remaining
variables. Computation removes the effect of all other variables in the matrix.
The user is encouraged to remove all known irrelevant rows and columns 
from the R matrix before submitting it to this function.
}
\note{
This function calls \code{\link{minor}}, and \code{\link{cofactor}}
}
\examples{

\dontrun{
set.seed(34);x=matrix(sample(1:600)[1:99],ncol=3)
colnames(x)=c('V1', 'v2', 'V3')
c1=cor(x)
parcor_linear(c1, 2,3)
}

}
\seealso{
See  \code{\link{parcor_ijk}} for generalized partial
 correlation coefficients useful for causal path determinations.
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY.
}
