% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outOFsell.R
\name{outOFsell}
\alias{outOFsell}
\title{Compare out-of-sample (short) selling algorithms by a leave-percent-out method.}
\usage{
outOFsell(mtx, pctOut = 5, reps = 10, seed = 23, maxChosen = 2, verbo = FALSE)
}
\arguments{
\item{mtx}{{matrix size n by p of data on n returns from p stocks}}

\item{pctOut}{{percent of n randomly chosen rows left out as out-of-sample, default=5
percent. One must leave out at least two rows of data}}

\item{reps}{{number of random repetitions of left-out rows over which we average
the out-of-sample performance of a stock-picking algorithm,
default reps=20}}

\item{seed}{{seed for random number generation, default =23}}

\item{maxChosen}{{number of stocks (out of p) with nonzero weights in the portfolio}}

\item{verbo}{{logical, TRUE means print details, default=FALSE}}
}
\value{
a matrix called `avgRet' with seven columns for seven stock-picking
algorithms "SD1","SD2","SD3","SD4","SDAll4","decile",and "moment," containing
out-of-sample average returns for linearly declining allocation in a portfolio.
User needs to change rank2sell() for alternate portfolio allocations.
}
\description{
This function randomly leaves out 5 percent (`pctOut'=5 by default) 
data and finds portfolio choice to sell by seven different
portfolio selection algorithms using the data on the remaining 95 percent (say). 
The randomization removes any bias in time series definitions of `out-of-sample' data.
For example, the input to \code{outOFsamp(.)} named `mtx' is a matrix with 
p columns for p stocks and n returns. Also, let  the maximum number of
stocks admitted to belong in the sell portfolio be four, or `maxChosen=4'.
Now \code{outOFsamp} function computes the returns earned by the
seven portfolio selection algorithms, called
"SD1", "SD2", "SD3", "SD4", "SDAll4", "decile," and "moment," where SDAll4 refers
to a weighted sum of SD1 to SD4 algorithms. Each algorithm provides
a choice ranking of p stocks with choice values 1,2,3,..,p where stock ranked
p should get the highest portfolio weight. (worst is sold)
The \code{outOFsamp} function then calls the
function `rank2sell,' which uses these rank choice numbers to the selected
`maxChosen' stocks.  The allocation is linearly declining. For example, it is
1/10, 2/10, 3/10, and 4/10, with the worst return stock
(top choice for selling)  receiving highest proportion of the capital
designated for selling.
Each choice of `pctOut' rows of the `mtx' data yields an outOFsamp return for each
of the seven portfolio selection algorithms.  These outOFsamp return
computations are repeated \code{reps} times. 
A new random selection of `pctOut' rows (must be 2 or more) of data is made
for each repetition. We set 
reps=20 by default. The low default is set
to save processing time in early phases, but we recommend reps=100+. 
 The final choice of stock-selling algorithm out of seven
is suggested by the average out-of-sample return over the `reps' repetitions.
This function is sell version of \code{outOFsamp()}.
}
\note{
The traditional time-series out-of-sample leaves out the last few
time periods, and estimates the stock-picking model using part of the data
time periods. The pandemic of 2019 has revealed that the traditional
out-of-sample would have a severe bias in favor of pessimistic stock-picking
algorithms.  The traditional method is fundamentally flawed since it is
sensitive to the trends (ups and downs) in the out-of-sample period. The
method proposed here is free from such biases. The stock-picking algorithm
recommended by our outOFsamp() is claimed to be robust against such biases.
}
\examples{
\dontrun{
x1=c(2,5,6,9,13,18,21,5,11,14,4,7,12,13,6,3,8,1,15,2,10,9)
x2=c(3,6,9,12,14,19,27,9,11,2,3,8,1,6,15,10,13,14,5,7,4,12)
x3=c(2,6,NA,11,13,25,25,11,9,10,12,6,4,3,2,1,7,8,5,15,14,13)
mtx=cbind(x1,x2,x3)
mtx=mtx[complete.cases(mtx),]
os=outOFsell(mtx,verbo=FALSE,maxChosen=2, reps=3)
apply(os,2,mean)}
}
\seealso{
\code{\link{rank2sell}}
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
