% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_unique_ngs.R
\name{.resolve_duplicates}
\alias{.resolve_duplicates}
\title{Select unique NGS report when multiple are available}
\usage{
.resolve_duplicates(x, data_cohort, oncotree_code, sample_type, min_max_time)
}
\arguments{
\item{x}{sample ID to select unique NGS report for}

\item{data_cohort}{output object of the create_analytic_cohort function.}

\item{oncotree_code}{character vector specifying which sample
OncoTree codes to keep. See "cpt_oncotree_code" column
of data_cohort argument above to get options.}

\item{sample_type}{character specifying which type of genomic sample
to prioritize, options are "Primary", "Local" and "Metastasis".
Default is to not select a NGS sample based on the sample type.}

\item{min_max_time}{character specifying if the first or last genomic
sample recorded should be kept.
Options are "min" (first) and "max" (last).}
}
\value{
a dataframe of samples with one observation per patient.
}
\description{
See `select_unique_ngs` for details on selection criteria
}
\examples{
\dontshow{if (genieBPC::.is_connected_to_genie()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
nsclc_2_0 <- pull_data_synapse("NSCLC", version = "v2.0-public")

ex1 <- create_analytic_cohort(
  data_synapse = nsclc_2_0$NSCLC_v2.0,
  stage_dx = c("Stage IV"),
  histology = "Adenocarcinoma"
)

 samples_data1 <- .resolve_duplicates(
   x = "GENIE-MSK-P-0025741",
  data_cohort = ex1$cohort_ngs,
  oncotree_code = "LUAD",
  sample_type = "Metastasis",
  min_max_time = "max"
)

samples_data2 <- .resolve_duplicates(
   x = "GENIE-MSK-P-0025741",
  data_cohort = ex1$cohort_ngs,
  oncotree_code = "LUAD",
  sample_type = "Primary",
  min_max_time = "max"
)
\dontshow{\}) # examplesIf}
}
\keyword{internal}
