% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LR_table.R
\name{LR_table}
\alias{LR_table}
\title{Compute pairwise likelihood ratios}
\usage{
LR_table(result_df, lr_populations = NULL, only_accepted = TRUE,
  CI = 0.95, digits = NULL)
}
\arguments{
\item{result_df}{The output from \code{genogeo}}

\item{lr_populations}{A vector of population names (\code{pop} in \code{result_df}). If NULL all populations are used.}

\item{only_accepted}{Restrict the ratios to include minimum one accepted population.}

\item{CI}{The level of confidence interval to be computed}

\item{digits}{If rounding of the output should be performed.}
}
\value{
A tibble with numerator and denominator populations with their log10 LR and uncertainty.
}
\description{
For each pair of a specified vector of profiles the likelihood ratios are computed.
The list can include all populations in the data or only a subset.
We may for inferral purposes restrict to ratios including at least one "accepted" population.
}
\examples{
df_ <- simulate_pops(pop_n = 4, aims_n = 50)
df_db <- pops_to_DB(df_)
profile <- random_AIMs_profile(df_db, keep_pop = TRUE)
profile$pop[1] # The true population
result <- genogeo(profile[,c("locus","x0")], df = df_db)
LR_table(result)
}
\author{
Torben Tvedebrink \email{tvede@math.aau.dk}
}
