% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rand_gen.R
\name{rexp_truncated}
\alias{rexp_truncated}
\title{Generates translated and truncated exponential variables.}
\usage{
rexp_truncated(n, lo, hi)
}
\arguments{
\item{n}{An integer, the number of samples to return.}

\item{lo}{A double, the lower limit of the distribution, cannot be \code{-Inf}.}

\item{hi}{A double, the upper limit of the distribution.}
}
\value{
\code{n} random variables from the translated truncated exponential distribution.
}
\description{
Generates translated and truncated exponential variables.
}
\details{
Returns \code{n} random variables from the translated truncated exponential distribution with density \eqn{\exp(-(x-lo))/(1-\exp(lo-hi))}{exp(-(x-lo))/(1-exp(lo-hi))} on \code{[lo,hi]}.
}
\examples{
hist(rexp_truncated(1e4, 0, Inf), breaks=200)
hist(rexp_truncated(1e4, 10, 12), breaks=200)
hist(rexp_truncated(1e4, -2, 2), breaks=200)
hist(rexp_truncated(1e4, -10, 0), breaks=200)
hist(rexp_truncated(1e4, -100, Inf), breaks=200)
hist(rexp_truncated(1e4, -100, -95), breaks=200)
}
