% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg.r
\name{reg}
\alias{reg}
\title{regress y on x with robust standard errors, clustered standard errors, HAC standard errors, panel fixed effects, etc}
\usage{
reg(y, x, subset = NULL, effect = NULL, robust = TRUE, hac = NULL,
  cluster = NULL, rtype = 1)
}
\arguments{
\item{y}{name of the dependent variable}

\item{x}{names of the independent variables in either "x1 x2 x3" format or ~x1+x2+x3 format. To include a variable as a categorical variable (when you would use "i.state" to get state dummies in Stata), include it as "factor(state)".}

\item{subset}{conditions to subset the data}

\item{effect}{either "twoways", "individual", or "time" for fixed effects.  Dataset must already have been \code{xtset}.}

\item{robust}{whether to use robust standard errors}

\item{hac}{which variable to order by to compute heteroskedastic and auto correlation standard errors (if unspecified, do not do HAC correction)}

\item{cluster}{a variable list giving the names of the variables to cluster by in producing clustered standard errors}

\item{rtype}{gives the type of heteroskedasticity correction to make.  By default, it is "1" to implement HC1 which is the same as Stata's small sample corrected standard errors.  rtype can be any integer from 0 to 3 with each value corresponding to a different heteroskedastic correction (HCx).  See documention for \code{vcovHC} in package \code{sandwich}.}
}
\value{
b coefficient vector

V covariance matrix of coefficients
}
\description{
regress y on x with robust standard errors, clustered standard errors, HAC standard errors, panel fixed effects, etc.
}
