% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-Methods.R
\docType{methods}
\name{spc.data2header}
\alias{spc.data2header}
\alias{spc.data2header,Spectra-method}
\title{Populate fields of header slot using data from data slot}
\usage{
spc.data2header(object,dataname,headerfield,compress,...)

\S4method{spc.data2header}{Spectra}(object, dataname, headerfield,
  compress = FALSE, ...)
}
\arguments{
\item{object}{A \code{Spectra} object.}

\item{dataname}{A character object specifying the name of @data column to be used.}

\item{headerfield}{A character object specifying the name of the @header field to be changed}

\item{compress}{logical. Whether or not to compress data put into the header. 
See the description section.}

\item{...}{arguments to be passed to or from other methods}
}
\value{
object of class \code{Spectra}
}
\description{
Populates a field of @header with a column data from @data slot.
}
\details{
This function extracts data from a column of the @data slot (specified by dataname)  
and creates a new @header field with it. Ifa header field is not provided, the name 
of the new header field will be the same as dataname. 

The name of the new header field can be overwritten by providing header field.
If all the incoming data rows (dataname) are the same, information put into the header 
can be compressed by selecting compress=TRUE (default is FALSE). This would take only 
the first element from the @data column.
}
\examples{
sp=spc.example_spectra()
sp=spc.data2header(sp,"CAST")
sp@header
sp=spc.data2header(sp,"CAST","ProjectCast")
sp@header
sp$CAST=rep(33, nrow(sp))
sp=spc.data2header(sp,"CAST","ProjectCast", compress=TRUE)
sp@header

}
