% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-Methods.R
\name{spc.export.text}
\alias{spc.export.text}
\alias{spc.export.text,Spectra-method}
\alias{spc.export.text,SpcHeader-method}
\alias{spc.import.text}
\title{Exporting into text format}
\usage{
spc.export.text(
  input,
  filename,
  sep = ";",
  append = FALSE,
  writeheader = TRUE,
  ...
)

\S4method{spc.export.text}{Spectra}(
  input,
  filename,
  sep = ";",
  append = FALSE,
  writeheader = TRUE,
  ...
)

\S4method{spc.export.text}{SpcHeader}(
  input,
  filename,
  sep = ";",
  append = FALSE,
  writeheader = TRUE,
  ...
)

spc.import.text(filename, sep = ";", ...)
}
\arguments{
\item{input}{A \code{Spectra} object}

\item{filename}{Name of the output text file}

\item{sep}{character. the field separator string}

\item{append}{logical. Only relevant if file is a character string. Default is  TRUE}

\item{writeheader}{either a logical value indicating whether the header names  are to be written}

\item{...}{arguments to be passed to or from other methods}
}
\description{
Save the \code{Spectra} and \code{SpcHeader} objects on disk in text format and read back in.
}
\examples{
x=spc.example_spectra()
fn <- tempfile()
spc.export.text(x,filename=fn)
aa=spc.import.text(fn)
dev.new()
spc.plot(aa)

#Export the SpcHeader object
fn2 <- tempfile()
spc.export.text(x@header, filename=fn2)
hdr=spc.import.text(fn2)
class(hdr)

}
\seealso{
\code{\link{spc.import.text}}
}
