% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localsurface.R
\name{findpeaks}
\alias{findpeaks}
\title{Find Local Peaks}
\usage{
findpeaks(x)
}
\arguments{
\item{x}{A raster or matrix.}
}
\value{
A dataframe of local peak locations (\code{x, y}) and
  values (\code{val}). The raster or matrix location index (\code{ind}),
  row (\code{row}), and column (\code{col}) are also listed.
}
\description{
Locates local peaks on a raster or matrix. A peak is defined as any pixel where
all 8 surrounding pixels have lower values, and the center pixel
has a positive value.
}
\examples{
# import raster image
data(normforest)

# locate peaks
peaks <- findpeaks(normforest)

# calculate the summit density (# peaks/area)
N <- ncol(normforest)
M <- nrow(normforest)
Sds <- nrow(peaks) / ((N - 1) * (M - 1))
}
