% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotXyz.r
\name{plotXyz}
\alias{plotXyz}
\title{Plot XYZ Points}
\usage{
plotXyz(Profile, xlab = "Length [m]", ylab = "Depth [m]",
  main = paste(Profile@title, "without topography"), asp = 1, ...)
}
\arguments{
\item{Profile}{profile.}

\item{xlab}{label for x-axes.}

\item{ylab}{label for y-axes.}

\item{main}{title to be plotted.}

\item{asp}{the y/x aspect ratio (default: 1).}

\item{...}{plot parameters}
}
\description{
Plots the interpolated points of the xyz data.
}
\examples{
data(sinkhole)

plotXyz(sinkhole@profiles[[1]])
}
\seealso{
\code{\link{Profile-class}}, \code{\link{plotXyzHeight}}, 
\code{\link{plot3dXyz}}, 
\code{\link{levelplotXyz}}, \code{\link{levelplotXyzHeight}}
}

