% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_departaments.R
\name{get_departaments}
\alias{get_departaments}
\title{Download the Departament limits of INEI}
\usage{
get_departaments(dsn = NULL, show_progress = TRUE, quiet = TRUE)
}
\arguments{
\item{dsn}{Character. Output filename. If missing, a temporary file is created.}

\item{show_progress}{Logical. Suppress bar progress.}

\item{quiet}{Logical. Suppress info message.}
}
\value{
A sf or tibble object.
}
\description{
This function allows you to download the latest version of the \bold{geometry} and \bold{ubigeos}
corresponding to the \bold{official political division} of the departament boundaries of Peru.
For more information, you can visit the following page \url{https://ide.inei.gob.pe/}
}
\examples{
\donttest{
library(geoidep)
dep <- get_departaments(show_progress = FALSE)
head(dep)
}
}
