% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOFeatureAttribute.R
\docType{class}
\name{ISOFeatureAttribute}
\alias{ISOFeatureAttribute}
\title{ISOFeatureAttribute}
\format{\code{\link{R6Class}} object.}
\usage{
ISOFeatureAttribute
}
\value{
Object of \code{\link{R6Class}} for modelling an ISOFeatureAttribute
}
\description{
ISOFeatureAttribute
}
\section{Fields}{

\describe{
\item{\code{listedValue}}{}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an ISOFeatureAttribute
 }
 \item{\code{setCode(code)}}{
   Sets the code
 }
 \item{\code{setValueMeasurementUnit(uom)}}{
   Sets the value measurement unit, an object of class \code{GMLUnitDefinition}
 }
 \item{\code{setValueType(typeName)}}{
   Sets the value type
 }
 \item{\code{addListedValue(value)}}{
   Adds a listed value (object of class \code{ISOListedValue})
 }
 \item{\code{delListedValue(value)}}{
  Deletes a listed value (object of class \code{ISOListedValue})
 }
}
}

\examples{
  md <- ISOFeatureAttribute$new()
  md$setMemberName("name")
  md$setDefinition("definition")
  md$setCardinality(lower=1,upper=1)
  md$setCode("code")
  
  gml <- GMLBaseUnit$new(id = "ID")
  gml$setDescriptionReference("someref")
  gml$setIdentifier("identifier", "codespace")
  gml$addName("name1", "codespace")
  gml$addName("name2", "codespace")
  gml$setQuantityTypeReference("someref")
  gml$setCatalogSymbol("symbol")
  gml$setUnitsSystem("somelink")
  md$setValueMeasurementUnit(gml)
  
  val1 <- ISOListedValue$new()
  val1$setCode("code1")
  val1$setLabel("label1")
  val1$setDefinition("definition1")
  md$addListedValue(val1)
  val2 <- ISOListedValue$new()
  val2$setCode("code2")
  val2$setLabel("label2")
  val2$setDefinition("definition2")
  md$addListedValue(val2)
  md$setValueType("typeName")
 
}
\references{
ISO 19110:2005 Methodology for Feature cataloguing
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{feature}
\keyword{operation}
