% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOProcessStep.R
\docType{class}
\name{ISOProcessStep}
\alias{ISOProcessStep}
\title{ISOProcessStep}
\format{\code{\link{R6Class}} object.}
\usage{
ISOProcessStep
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO ProcessStep
}
\description{
ISOProcessStep
}
\section{Fields}{

\describe{
\item{\code{description}}{[\code{\link{character}}] process step description}

\item{\code{rationale}}{[\code{\link{character}}] rationale}

\item{\code{dateTime}}{[\code{\link{POSIXt}}] dateTime of the process ste}

\item{\code{processor}}{[\code{\link{ISOResponsibleParty}}] party responsible of the process step}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOProcessStep}}
 }
 \item{\code{setDescription(description, locales)}}{
   Sets the process step description. Locale names can be specified as \code{list}
   with the \code{locales} argument.
 }
 \item{\code{setRationale(rationale, locales)}}{
   Sets the process step rationale. Locale names can be specified as \code{list}
   with the \code{locales} argument.
 }
 \item{\code{setDateTime(dateTime)}}{
   Sets the date time
 }
 \item{addProcessor(processor)}{
   Adds a processor (object of class \code{\link{ISOResponsibleParty}})
 }
 \item{delProcessor(processor)}{
  Deletes a processor
 }
 \item{addSource(source)}{
   Adds a source (object of class \code{\link{ISOSource}})
 }
 \item{delSource(source)}{
  Deletes a source
 }
}
}

\examples{
  ps <- ISOProcessStep$new()
  ps$setDescription("description")
  ps$setRationale("rationale")
  ps$setDateTime( ISOdate(2015, 1, 1, 23, 59, 59))
  rp <- ISOResponsibleParty$new()
  rp$setIndividualName("someone") #and more responsible party properties..
  ps$addProcessor(rp)
  xml <- ps$encode()
  
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{process}
\keyword{step}
